// src/use-swr-store.tsx
import {
  createEffect,
  createResource,
  createSignal,
  onCleanup
} from "solid-js";
function useSWRStoreSuspenseless(store, args, options) {
  const [result, setResult] = createSignal(store.get(args(), {
    shouldRevalidate: options.shouldRevalidate,
    initialData: options.initialData,
    hydrate: options.hydrate
  }));
  createEffect(() => {
    const currentArgs = args();
    onCleanup(store.subscribe(currentArgs, () => {
      setResult(() => store.get(currentArgs, {
        shouldRevalidate: false
      }));
    }));
  });
  return result;
}
function useSWRStore(store, args, options) {
  const suspenseless = useSWRStoreSuspenseless(store, args, options);
  const [resource] = createResource(
    suspenseless,
    async (result) => {
      if (result.status === "failure") {
        throw result.data;
      }
      return result.data;
    },
    "initialData" in options ? {
      initialValue: options.initialData,
      ssrLoadFrom: "initial"
    } : {}
  );
  return resource;
}
export {
  useSWRStore,
  useSWRStoreSuspenseless
};
//# sourceMappingURL=index.mjs.map
