"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  useSWRStore: () => useSWRStore,
  useSWRStoreSuspenseless: () => useSWRStoreSuspenseless
});
module.exports = __toCommonJS(src_exports);

// src/use-swr-store.tsx
var import_solid_js = require("solid-js");
function useSWRStoreSuspenseless(store, args, options) {
  const [result, setResult] = (0, import_solid_js.createSignal)(store.get(args(), {
    shouldRevalidate: options.shouldRevalidate,
    initialData: options.initialData,
    hydrate: options.hydrate
  }));
  (0, import_solid_js.createEffect)(() => {
    const currentArgs = args();
    (0, import_solid_js.onCleanup)(store.subscribe(currentArgs, () => {
      setResult(() => store.get(currentArgs, {
        shouldRevalidate: false
      }));
    }));
  });
  return result;
}
function useSWRStore(store, args, options) {
  const suspenseless = useSWRStoreSuspenseless(store, args, options);
  const [resource] = (0, import_solid_js.createResource)(
    suspenseless,
    async (result) => {
      if (result.status === "failure") {
        throw result.data;
      }
      return result.data;
    },
    "initialData" in options ? {
      initialValue: options.initialData,
      ssrLoadFrom: "initial"
    } : {}
  );
  return resource;
}
//# sourceMappingURL=index.cjs.map
