/* eslint-disable no-magic-numbers */
import { EncoderMap } from './EncoderMap.js';
import { EndOfPrompt, EndOfText, FimMiddle, FimPrefix, FimSuffix, ImEnd, ImSep, ImStart, } from './specialTokens.js';
const tokenSplitRegex = /'s|'t|'re|'ve|'m|'ll|'d| ?\p{L}+| ?\p{N}+| ?[^\s\p{L}\p{N}]+|\s+(?!\S)|\s+/gu;
function R50KBase(mergeableBytePairRanks) {
    return {
        expectedVocabularySize: 50257,
        tokenSplitRegex,
        mergeableBytePairRanks,
        specialTokenMapping: new Map([[EndOfText, 50256]]),
    };
}
function P50KBase(mergeableBytePairRanks) {
    return {
        expectedVocabularySize: 50281,
        tokenSplitRegex,
        mergeableBytePairRanks,
        specialTokenMapping: new Map([[EndOfText, 50256]]),
    };
}
function P50KEdit(mergeableBytePairRanks) {
    const specialTokenMapping = new Map([
        [EndOfText, 50256],
        [FimPrefix, 50281],
        [FimMiddle, 50282],
        [FimSuffix, 50283],
    ]);
    return {
        tokenSplitRegex,
        mergeableBytePairRanks,
        specialTokenMapping,
    };
}
function Cl100KBase(mergeableBytePairRanks) {
    const specialTokenMapping = new Map([
        [EndOfText, 100257],
        [FimPrefix, 100258],
        [FimMiddle, 100259],
        [FimSuffix, 100260],
        [ImStart, 100264],
        [ImEnd, 100265],
        [ImSep, 100266],
        [EndOfPrompt, 100276],
    ]);
    return {
        tokenSplitRegex: /(?:'s|'t|'re|'ve|'m|'ll|'d)|[^\r\n\p{L}\p{N}]?\p{L}+|\p{N}{1,3}| ?[^\s\p{L}\p{N}]+[\r\n]*|\s*[\r\n]+|\s+(?!\S)|\s+/giu,
        mergeableBytePairRanks,
        specialTokenMapping,
    };
}
export function getEncodingParams(encodingName, getMergeableRanks) {
    const mergeableBytePairRanks = getMergeableRanks(encodingName);
    switch (encodingName.toLowerCase()) {
        case 'r50k_base':
            return R50KBase(mergeableBytePairRanks);
        case 'p50k_base':
            return P50KBase(mergeableBytePairRanks);
        case 'p50k_edit':
            return P50KEdit(mergeableBytePairRanks);
        case 'cl100k_base':
            return Cl100KBase(mergeableBytePairRanks);
        default:
            throw new Error(`Unknown encoding name: ${encodingName}`);
    }
}
export async function getModelParamsAsync(encodingName, getMergeableRanks) {
    const mergeableBytePairRanks = await getMergeableRanks(encodingName);
    return getEncodingParams(encodingName, () => mergeableBytePairRanks);
}
//# sourceMappingURL=modelParams.js.map