"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.endsWithIncompleteUtfPairSurrogate = void 0;
const HIGH_SURROGATE_START = 55296;
const HIGH_SURROGATE_END = 56319;
function endsWithIncompleteUtfPairSurrogate(string) {
    if (string.length === 0)
        return false;
    // Check if the last character is a high surrogate
    // eslint-disable-next-line unicorn/prefer-code-point
    const lastCharCode = string.charCodeAt(string.length - 1);
    return (lastCharCode >= HIGH_SURROGATE_START && lastCharCode <= HIGH_SURROGATE_END);
}
exports.endsWithIncompleteUtfPairSurrogate = endsWithIncompleteUtfPairSurrogate;
//# sourceMappingURL=utfUtil.js.map