"use strict";
/* eslint-disable @typescript-eslint/no-explicit-any */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncLocalStorageProviderSingleton = exports.MockAsyncLocalStorage = void 0;
class MockAsyncLocalStorage {
    getStore() {
        return undefined;
    }
    run(_store, callback) {
        callback();
    }
}
exports.MockAsyncLocalStorage = MockAsyncLocalStorage;
class AsyncLocalStorageProvider {
    constructor() {
        Object.defineProperty(this, "asyncLocalStorage", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new MockAsyncLocalStorage()
        });
        Object.defineProperty(this, "hasBeenInitialized", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
    }
    getInstance() {
        return this.asyncLocalStorage;
    }
    initializeGlobalInstance(instance) {
        if (!this.hasBeenInitialized) {
            this.hasBeenInitialized = true;
            this.asyncLocalStorage = instance;
        }
    }
}
const AsyncLocalStorageProviderSingleton = new AsyncLocalStorageProvider();
exports.AsyncLocalStorageProviderSingleton = AsyncLocalStorageProviderSingleton;
