"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseListChatMessageHistory = exports.BaseChatMessageHistory = void 0;
const serializable_js_1 = require("./load/serializable.cjs");
const index_js_1 = require("./messages/index.cjs");
/**
 * Base class for all chat message histories. All chat message histories
 * should extend this class.
 */
class BaseChatMessageHistory extends serializable_js_1.Serializable {
}
exports.BaseChatMessageHistory = BaseChatMessageHistory;
/**
 * Base class for all list chat message histories. All list chat message
 * histories should extend this class.
 */
class BaseListChatMessageHistory extends serializable_js_1.Serializable {
    /**
     * This is a convenience method for adding a human message string to the store.
     * Please note that this is a convenience method. Code should favor the
     * bulk addMessages interface instead to save on round-trips to the underlying
     * persistence layer.
     * This method may be deprecated in a future release.
     */
    addUserMessage(message) {
        return this.addMessage(new index_js_1.HumanMessage(message));
    }
    /** @deprecated Use addAIMessage instead */
    addAIChatMessage(message) {
        return this.addMessage(new index_js_1.AIMessage(message));
    }
    /**
     * This is a convenience method for adding an AI message string to the store.
     * Please note that this is a convenience method. Code should favor the bulk
     * addMessages interface instead to save on round-trips to the underlying
     * persistence layer.
     * This method may be deprecated in a future release.
     */
    addAIMessage(message) {
        return this.addMessage(new index_js_1.AIMessage(message));
    }
    /**
     * Add a list of messages.
     *
     * Implementations should override this method to handle bulk addition of messages
     * in an efficient manner to avoid unnecessary round-trips to the underlying store.
     *
     * @param messages - A list of BaseMessage objects to store.
     */
    async addMessages(messages) {
        for (const message of messages) {
            await this.addMessage(message);
        }
    }
    /**
     * Remove all messages from the store.
     */
    clear() {
        throw new Error("Not implemented.");
    }
}
exports.BaseListChatMessageHistory = BaseListChatMessageHistory;
