"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const plugin = async ctx => {
  const {
    WatcherServerPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new WatcherServerPlugin(ctx);
};
exports.plugin = plugin;
const config = exports.config = {
  schema: _configSchema.schema.object({
    enabled: (0, _configSchema.offeringBasedSchema)({
      // Watcher is disabled in serverless; refer to the serverless.yml file as the source of truth
      // We take this approach in order to have a central place (serverless.yml) to view disabled plugins across Kibana
      serverless: _configSchema.schema.boolean({
        defaultValue: true
      })
    })
  })
};