"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchStateBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stateToColorMap = {
  [_constants.WATCH_STATES.ACTIVE]: 'success',
  [_constants.WATCH_STATES.INACTIVE]: 'subdued',
  [_constants.WATCH_STATES.CONFIG_ERROR]: 'subdued',
  [_constants.WATCH_STATES.ERROR]: 'subdued'
};
const WatchStateBadge = ({
  state,
  size = 's'
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    color: stateToColorMap[state]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: size
  }, state)));
};
exports.WatchStateBadge = WatchStateBadge;