"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationMissedSavedObjectError = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const VisualizationMissedSavedObjectError = ({
  savedObjectMeta,
  application,
  message,
  renderMode
}) => {
  const {
    management: isManagementEnabled
  } = application.capabilities.navLinks;
  const isIndexPatternManagementEnabled = application.capabilities.management.kibana.indexPatterns;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    "data-test-subj": "visualization-missed-data-view-error",
    actions: savedObjectMeta.savedObjectType === _common.DATA_VIEW_SAVED_OBJECT_TYPE && renderMode === 'edit' && isManagementEnabled && isIndexPatternManagementEnabled ? /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      navigateToUrl: application.navigateToUrl
    }, /*#__PURE__*/_react.default.createElement("a", {
      href: application.getUrlForApp('management', {
        path: '/kibana/indexPatterns/create'
      }),
      "data-test-subj": "configuration-failure-reconfigure-indexpatterns",
      style: {
        width: '100%'
      }
    }, _i18n.i18n.translate('visualizations.missedDataView.dataViewReconfigure', {
      defaultMessage: `Recreate it in the data view management page`
    }))) : null,
    body: /*#__PURE__*/_react.default.createElement("p", null, message)
  });
};
exports.VisualizationMissedSavedObjectError = VisualizationMissedSavedObjectError;