"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YAxisModes = exports.XYCurveTypes = exports.SeriesTypes = exports.RANGE_MODES = exports.PartitionChartTypes = exports.OperationsWithSourceField = exports.OperationsWithReferences = exports.Operations = exports.NumberDisplayTypes = exports.LegendDisplayTypes = exports.LayerTypes = exports.GaugeTicksPositions = exports.GaugeShapes = exports.GaugeLabelMajorModes = exports.GaugeColorModes = exports.GaugeCentralMajorModes = exports.FillTypes = exports.CollapseFunctions = exports.CategoryDisplayTypes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OperationsWithSourceField = exports.OperationsWithSourceField = {
  FILTERS: 'filters',
  RANGE: 'range',
  TERMS: 'terms',
  DATE_HISTOGRAM: 'date_histogram',
  MIN: 'min',
  MAX: 'max',
  AVERAGE: 'average',
  SUM: 'sum',
  MEDIAN: 'median',
  STANDARD_DEVIATION: 'standard_deviation',
  UNIQUE_COUNT: 'unique_count',
  PERCENTILE: 'percentile',
  PERCENTILE_RANK: 'percentile_rank',
  COUNT: 'count',
  LAST_VALUE: 'last_value'
};
const OperationsWithReferences = exports.OperationsWithReferences = {
  CUMULATIVE_SUM: 'cumulative_sum',
  COUNTER_RATE: 'counter_rate',
  DIFFERENCES: 'differences',
  MOVING_AVERAGE: 'moving_average',
  FORMULA: 'formula',
  STATIC_VALUE: 'static_value',
  NORMALIZE_BY_UNIT: 'normalize_by_unit'
};
const Operations = exports.Operations = {
  ...OperationsWithSourceField,
  ...OperationsWithReferences
};
const PartitionChartTypes = exports.PartitionChartTypes = {
  PIE: 'pie',
  DONUT: 'donut',
  TREEMAP: 'treemap',
  MOSAIC: 'mosaic',
  WAFFLE: 'waffle'
};
const CategoryDisplayTypes = exports.CategoryDisplayTypes = {
  DEFAULT: 'default',
  INSIDE: 'inside',
  HIDE: 'hide'
};
const NumberDisplayTypes = exports.NumberDisplayTypes = {
  HIDDEN: 'hidden',
  PERCENT: 'percent',
  VALUE: 'value'
};
const LegendDisplayTypes = exports.LegendDisplayTypes = {
  DEFAULT: 'default',
  SHOW: 'show',
  HIDE: 'hide'
};
const LayerTypes = exports.LayerTypes = {
  DATA: 'data',
  REFERENCELINE: 'referenceLine',
  ANNOTATIONS: 'annotations'
};
const XYCurveTypes = exports.XYCurveTypes = {
  LINEAR: 'LINEAR',
  CURVE_MONOTONE_X: 'CURVE_MONOTONE_X',
  CURVE_STEP_AFTER: 'CURVE_STEP_AFTER'
};
const YAxisModes = exports.YAxisModes = {
  AUTO: 'auto',
  LEFT: 'left',
  RIGHT: 'right',
  BOTTOM: 'bottom'
};
const SeriesTypes = exports.SeriesTypes = {
  BAR: 'bar',
  LINE: 'line',
  AREA: 'area',
  BAR_STACKED: 'bar_stacked',
  AREA_STACKED: 'area_stacked',
  BAR_HORIZONTAL: 'bar_horizontal',
  BAR_PERCENTAGE_STACKED: 'bar_percentage_stacked',
  BAR_HORIZONTAL_STACKED: 'bar_horizontal_stacked',
  AREA_PERCENTAGE_STACKED: 'area_percentage_stacked',
  BAR_HORIZONTAL_PERCENTAGE_STACKED: 'bar_horizontal_percentage_stacked'
};
const FillTypes = exports.FillTypes = {
  NONE: 'none',
  ABOVE: 'above',
  BELOW: 'below'
};
const RANGE_MODES = exports.RANGE_MODES = {
  Range: 'range',
  Histogram: 'histogram'
};
const GaugeShapes = exports.GaugeShapes = {
  HORIZONTAL_BULLET: 'horizontalBullet',
  VERTICAL_BULLET: 'verticalBullet',
  SEMI_CIRCLE: 'semiCircle',
  ARC: 'arc',
  CIRCLE: 'circle'
};
const GaugeTicksPositions = exports.GaugeTicksPositions = {
  HIDDEN: 'hidden',
  AUTO: 'auto',
  BANDS: 'bands'
};
const GaugeLabelMajorModes = exports.GaugeLabelMajorModes = {
  AUTO: 'auto',
  CUSTOM: 'custom',
  NONE: 'none'
};
const GaugeCentralMajorModes = exports.GaugeCentralMajorModes = {
  AUTO: 'auto',
  CUSTOM: 'custom',
  NONE: 'none'
};
const GaugeColorModes = exports.GaugeColorModes = {
  PALETTE: 'palette',
  NONE: 'none'
};
const CollapseFunctions = exports.CollapseFunctions = ['sum', 'avg', 'min', 'max'];