"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeConstants = exports.VISUALIZE_EMBEDDABLE_TYPE = exports.VISUALIZE_APP_NAME = exports.SUPPORTED_AGGREGATIONS = exports.STATE_STORAGE_KEY = exports.SAVED_OBJECTS_PER_PAGE_SETTING = exports.SAVED_OBJECTS_LIMIT_SETTING = exports.LegendSizeToPixels = exports.LegendSize = exports.GLOBAL_STATE_STORAGE_KEY = exports.DEFAULT_LEGEND_SIZE = void 0;
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SAVED_OBJECTS_LIMIT_SETTING = exports.SAVED_OBJECTS_LIMIT_SETTING = 'savedObjects:listingLimit';
const SAVED_OBJECTS_PER_PAGE_SETTING = exports.SAVED_OBJECTS_PER_PAGE_SETTING = 'savedObjects:perPage';
const VISUALIZE_EMBEDDABLE_TYPE = exports.VISUALIZE_EMBEDDABLE_TYPE = 'visualization';
const STATE_STORAGE_KEY = exports.STATE_STORAGE_KEY = '_a';
const GLOBAL_STATE_STORAGE_KEY = exports.GLOBAL_STATE_STORAGE_KEY = '_g';
const VISUALIZE_APP_NAME = exports.VISUALIZE_APP_NAME = 'visualize';
const VisualizeConstants = exports.VisualizeConstants = {
  VISUALIZE_BASE_PATH: '/app/visualize',
  LANDING_PAGE_PATH: '/',
  LANDING_PAGE_PATH_WITH_TAB: '/:activeTab',
  WIZARD_STEP_1_PAGE_PATH: '/new',
  WIZARD_STEP_2_PAGE_PATH: '/new/configure',
  CREATE_PATH: '/create',
  EDIT_PATH: '/edit',
  EDIT_BY_VALUE_PATH: '/edit_by_value',
  APP_ID: 'visualize'
};
let LegendSize = exports.LegendSize = /*#__PURE__*/function (LegendSize) {
  LegendSize["AUTO"] = "auto";
  LegendSize["SMALL"] = "small";
  LegendSize["MEDIUM"] = "medium";
  LegendSize["LARGE"] = "large";
  LegendSize["EXTRA_LARGE"] = "xlarge";
  return LegendSize;
}({});
const LegendSizeToPixels = exports.LegendSizeToPixels = {
  [LegendSize.AUTO]: undefined,
  [LegendSize.SMALL]: 80,
  [LegendSize.MEDIUM]: 130,
  [LegendSize.LARGE]: 180,
  [LegendSize.EXTRA_LARGE]: 230
};
const DEFAULT_LEGEND_SIZE = exports.DEFAULT_LEGEND_SIZE = LegendSize.MEDIUM;
const SUPPORTED_AGGREGATIONS = exports.SUPPORTED_AGGREGATIONS = [...Object.values(_common.METRIC_TYPES), ...Object.values(_common.BUCKET_TYPES)];