"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueAxisOptions = ValueAxisOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _label_options = require("./label_options");
var _custom_extents_options = require("./custom_extents_options");
var _collections = require("../../../collections");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const collections = (0, _collections.getConfigCollections)();
function ValueAxisOptions({
  axis,
  index,
  valueAxis,
  onValueAxisPositionChanged,
  setParamByIndex,
  setMultipleValidity
}) {
  const setValueAxis = (0, _react.useCallback)((paramName, value) => setParamByIndex('valueAxes', index, paramName, value), [setParamByIndex, index]);
  const setValueAxisTitle = (0, _react.useCallback)((paramName, value) => {
    const title = {
      ...valueAxis.title,
      [paramName]: value
    };
    setParamByIndex('valueAxes', index, 'title', title);
  }, [valueAxis.title, setParamByIndex, index]);
  const setValueAxisScale = (0, _react.useCallback)((paramName, value) => {
    const scale = {
      ...valueAxis.scale,
      [paramName]: value
    };
    setParamByIndex('valueAxes', index, 'scale', scale);
  }, [valueAxis.scale, setParamByIndex, index]);
  const setAxisLabel = (0, _react.useCallback)((paramName, value) => {
    const labels = {
      ...valueAxis.labels,
      [paramName]: value
    };
    setParamByIndex('valueAxes', index, 'labels', labels);
  }, [valueAxis.labels, setParamByIndex, index]);
  const onPositionChanged = (0, _react.useCallback)((paramName, value) => {
    onValueAxisPositionChanged(index, value);
  }, [index, onValueAxisPositionChanged]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.positionLabel', {
      defaultMessage: 'Position'
    }),
    "data-test-subj": `valueAxisPosition-${axis.id}`,
    options: collections.positions,
    paramName: "position",
    value: axis.position,
    setValue: onPositionChanged
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: `valueAxisMode${index}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.modeLabel', {
      defaultMessage: 'Mode'
    }),
    options: collections.axisModes,
    paramName: "mode",
    value: axis.scale.mode,
    setValue: setValueAxisScale
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: `scaleSelectYAxis-${axis.id}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.scaleTypeLabel', {
      defaultMessage: 'Scale type'
    }),
    options: collections.scaleTypes,
    paramName: "type",
    value: axis.scale.type,
    setValue: setValueAxisScale
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.showLabel', {
      defaultMessage: 'Show axis lines and labels'
    }),
    "data-test-subj": `valueAxisShow-${axis.id}`,
    paramName: "show",
    value: axis.show,
    setValue: setValueAxis
  }), axis.show ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.TextInputOption, {
    "data-test-subj": `valueAxisTitle${index}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.titleLabel', {
      defaultMessage: 'Title'
    }),
    paramName: "text",
    value: axis.title.text,
    setValue: setValueAxisTitle
  }), /*#__PURE__*/_react.default.createElement(_label_options.LabelOptions, {
    axisLabels: axis.labels,
    axisFilterCheckboxName: `yAxisFilterLabelsCheckbox-${axis.id}`,
    setAxisLabel: setAxisLabel
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `yAxisOptionsAccordion${axis.id}`,
    className: "visEditorSidebar__section visEditorSidebar__collapsible",
    initialIsOpen: false,
    buttonContentClassName: "euiText euiText--small",
    buttonContent: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.customExtentsLabel', {
      defaultMessage: 'Custom extents'
    }),
    "aria-label": _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.toggleCustomExtendsAriaLabel', {
      defaultMessage: 'Toggle custom extents'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_custom_extents_options.CustomExtentsOptions, {
    axisScale: axis.scale,
    setMultipleValidity: setMultipleValidity,
    setValueAxisScale: setValueAxisScale,
    setValueAxis: setValueAxis,
    disableAxisExtents: axis.scale.mode === 'percentage'
  }))));
}