"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelOptions = LabelOptions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _common = require("../../common");
var _collections = require("../../../collections");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function LabelOptions({
  axisLabels,
  axisFilterCheckboxName,
  setAxisLabel,
  disableSingleLayerAxisControls
}) {
  const setAxisLabelRotate = (0, _react.useCallback)((paramName, value) => {
    const rotation = Number(value);
    setAxisLabel(paramName, rotation);
  }, [setAxisLabel]);
  const rotateOptions = (0, _react.useMemo)(_collections.getRotateOptions, []);
  const multilayerAxisTooltipText = disableSingleLayerAxisControls ? _i18n.i18n.translate('visTypeXy.controls.pointSeries.categoryAxis.axisLabelsOptionsMultilayer.disabled', {
    defaultMessage: 'This option can be configured only with non-time-based axes'
  }) : undefined;
  const axisLabelControlDisabled = !axisLabels.show || disableSingleLayerAxisControls;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.controls.pointSeries.categoryAxis.labelsTitle",
    defaultMessage: "Labels"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.categoryAxis.showLabelsLabel', {
      defaultMessage: 'Show labels'
    }),
    paramName: "show",
    value: axisLabels.show,
    setValue: setAxisLabel
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    "data-test-subj": axisFilterCheckboxName,
    disabled: axisLabelControlDisabled,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.categoryAxis.filterLabelsLabel', {
      defaultMessage: 'Filter labels'
    }),
    paramName: "filter",
    value: axisLabels.filter,
    setValue: setAxisLabel,
    tooltip: multilayerAxisTooltipText
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: multilayerAxisTooltipText,
    delay: "long",
    position: "right"
  }, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    disabled: axisLabelControlDisabled,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.categoryAxis.alignLabel', {
      defaultMessage: 'Align'
    }),
    options: rotateOptions,
    paramName: "rotate",
    value: axisLabels.rotate
    // @ts-ignore ts upgrade v4.7.4
    ,
    setValue: setAxisLabelRotate
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: multilayerAxisTooltipText,
    delay: "long",
    position: "right"
  }, /*#__PURE__*/_react.default.createElement(_common.TruncateLabelsOption, {
    disabled: axisLabelControlDisabled,
    value: axisLabels.truncate,
    setValue: setAxisLabel
  })))));
}