"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomExtentsOptions = CustomExtentsOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _y_extents = require("./y_extents");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function CustomExtentsOptions({
  axisScale,
  setMultipleValidity,
  setValueAxis,
  setValueAxisScale,
  disableAxisExtents = false
}) {
  const invalidBoundsMarginMessage = _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.scaleToDataBounds.minNeededBoundsMargin', {
    defaultMessage: 'Bounds margin must be greater than or equal to 0.'
  });
  const isBoundsMarginValid = !axisScale.defaultYExtents || !axisScale.boundsMargin || axisScale.boundsMargin >= 0;
  const setBoundsMargin = (0, _react.useCallback)((paramName, value) => setValueAxisScale(paramName, value === '' ? undefined : value), [setValueAxisScale]);
  const onDefaultYExtentsChange = (0, _react.useCallback)((paramName, value) => {
    const scale = {
      ...axisScale,
      [paramName]: value
    };
    if (!scale.defaultYExtents) {
      delete scale.boundsMargin;
    }
    setValueAxis('scale', scale);
  }, [axisScale, setValueAxis]);
  const onSetYExtentsChange = (0, _react.useCallback)((paramName, value) => {
    const scale = {
      ...axisScale,
      [paramName]: value
    };
    if (!scale.setYExtents) {
      delete scale.min;
      delete scale.max;
    }
    setValueAxis('scale', scale);
  }, [axisScale, setValueAxis]);
  (0, _react.useEffect)(() => {
    setMultipleValidity('boundsMargin', isBoundsMarginValid);
    return () => setMultipleValidity('boundsMargin', true);
  }, [isBoundsMarginValid, setMultipleValidity]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.scaleToDataBoundsLabel', {
      defaultMessage: 'Scale to data bounds'
    }),
    paramName: "defaultYExtents",
    value: axisScale.defaultYExtents,
    setValue: onDefaultYExtentsChange
  }), axisScale.defaultYExtents && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.NumberInputOption, {
    error: !isBoundsMarginValid && invalidBoundsMarginMessage,
    isInvalid: !isBoundsMarginValid,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.scaleToDataBounds.boundsMargin', {
      defaultMessage: 'Bounds margin'
    }),
    step: 0.1,
    min: 0,
    paramName: "boundsMargin",
    value: axisScale.boundsMargin,
    setValue: setBoundsMargin
  })), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    "data-test-subj": "yAxisSetYExtents",
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.setAxisExtentsLabel', {
      defaultMessage: 'Set axis extents'
    }),
    paramName: "setYExtents",
    value: axisScale.setYExtents,
    setValue: onSetYExtentsChange,
    disabled: disableAxisExtents
  }), axisScale.setYExtents && !disableAxisExtents && /*#__PURE__*/_react.default.createElement(_y_extents.YExtents, {
    scale: axisScale,
    setScale: setValueAxisScale,
    setMultipleValidity: setMultipleValidity
  }));
}