"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignalViewer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _inspector_data_grid = require("./inspector_data_grid");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initialSignalColumnWidth = 150;
const signalDataGridAriaLabel = _i18n.i18n.translate('visTypeVega.inspector.signalViewer.gridAriaLabel', {
  defaultMessage: 'Signal values data grid'
});
const SignalViewer = ({
  vegaAdapter
}) => {
  const [inspectSignalsSets, setInspectSignalsSets] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const subscription = vegaAdapter.getSignalsSetsSubscription().subscribe(signalSets => {
      if (signalSets) {
        setInspectSignalsSets(signalSets);
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [vegaAdapter]);
  if (!inspectSignalsSets) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_inspector_data_grid.InspectorDataGrid, {
    columns: inspectSignalsSets.columns.map((column, index) => {
      if (index === 0) {
        return {
          ...column,
          initialWidth: initialSignalColumnWidth
        };
      }
      return column;
    }),
    data: inspectSignalsSets.data,
    dataGridAriaLabel: signalDataGridAriaLabel
  }));
};
exports.SignalViewer = SignalViewer;