"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmsFileParser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _vega_base_view = require("../vega_view/vega_base_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-ignore

/**
 * This class processes all Vega spec customizations,
 * converting url object parameters into query results.
 */
class EmsFileParser {
  constructor(serviceSettings) {
    (0, _defineProperty2.default)(this, "_serviceSettings", void 0);
    (0, _defineProperty2.default)(this, "_fileLayersP", void 0);
    this._serviceSettings = serviceSettings;
  }

  // noinspection JSMethodCanBeStatic
  /**
   * Update request object, expanding any context-aware keywords
   */
  parseUrl(obj, url) {
    if (typeof url.name !== 'string') {
      throw new Error(_i18n.i18n.translate('visTypeVega.emsFileParser.missingNameOfFileErrorMessage', {
        defaultMessage: '{dataUrlParam} with {dataUrlParamValue} requires {nameParam} parameter (name of the file)',
        values: {
          dataUrlParam: '"data.url"',
          dataUrlParamValue: '{"%type%": "emsfile"}',
          nameParam: '"name"'
        }
      }));
    }

    // Optimization: so initiate remote request as early as we know that we will need it
    if (!this._fileLayersP) {
      this._fileLayersP = this._serviceSettings.getFileLayers();
    }
    return {
      obj,
      name: url.name
    };
  }

  /**
   * Process items generated by parseUrl()
   * @param {object[]} requests each object is generated by parseUrl()
   * @returns {Promise<void>}
   */
  async populateData(requests) {
    if (requests.length === 0) return;
    const layers = await this._fileLayersP;
    for (const {
      obj,
      name
    } of requests) {
      const foundLayer = layers === null || layers === void 0 ? void 0 : layers.find(v => v.name === name);
      if (!foundLayer) {
        throw new Error(_i18n.i18n.translate('visTypeVega.emsFileParser.emsFileNameDoesNotExistErrorMessage', {
          defaultMessage: '{emsfile} {emsfileName} does not exist',
          values: {
            emsfileName: JSON.stringify(name),
            emsfile: 'emsfile'
          }
        }));
      }

      // This URL can bypass loader sanitization at the later stage
      const url = await this._serviceSettings.getUrlForRegionLayer(foundLayer);
      obj.url = (0, _vega_base_view.bypassExternalUrlCheck)(url);
    }
  }
}
exports.EmsFileParser = EmsFileParser;