"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Annotation = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
require("./_annotation.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Annotation extends _react.Component {
  constructor(props) {
    super(props);
  }
  renderTooltip() {
    const [timestamp, messageSource] = this.props.series;
    const messages = messageSource.map((message, i) => {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: `${message}-${i}`,
        className: "tvbVisAnnotation__message"
      }, message);
    });
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbTooltip__timestamp"
    }, (0, _moment.default)(timestamp).format('lll')), messages);
  }
  render() {
    const {
      color,
      plot,
      icon,
      series
    } = this.props;
    const offset = plot.pointOffset({
      x: series[0],
      y: 0
    });
    const tooltip = this.renderTooltip();
    const containerCSS = (0, _react2.css)`
      left: ${offset.left - 6}px;
      bottom: 0;
      top: 5px;
    `;
    const lineCSS = (0, _react2.css)`
      backgroundcolor: ${color};
    `;
    const iconCSS = (0, _react2.css)`
      color: ${color};
    `;
    return /*#__PURE__*/_react.default.createElement("div", {
      css: containerCSS,
      className: "tvbVisAnnotation"
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: lineCSS,
      className: "tvbVisAnnotation__line"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      className: "tvbVisAnnotation__tooltip",
      content: tooltip,
      position: "top"
    }, /*#__PURE__*/_react.default.createElement("i", {
      css: iconCSS,
      className: `tvbVisAnnotation__icon fa ${icon}`
    })));
  }
}
exports.Annotation = Annotation;
Annotation.propTypes = {
  series: _propTypes.default.array,
  icon: _propTypes.default.string,
  color: _propTypes.default.string,
  plot: _propTypes.default.object
};