"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _get_metrics_field = require("../../lib/get_metrics_field");
var _tick_formatter = require("../../lib/tick_formatter");
var _create_field_formatter = require("../../lib/create_field_formatter");
var _check_if_series_have_same_formatters = require("../../lib/check_if_series_have_same_formatters");
var _timeseries = require("../../../visualizations/views/timeseries");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _common = require("@kbn/charts-plugin/common");
var _replace_vars = require("../../lib/replace_vars");
var _get_interval = require("../../lib/get_interval");
var _create_interval_based_formatter = require("../../lib/create_interval_based_formatter");
var _constants = require("../../../visualizations/constants");
var _services = require("../../../../services");
var _enums = require("../../../../../common/enums");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class TimeseriesVisualization extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "scaledDataFormat", this.props.getConfig('dateFormat:scaled'));
    (0, _defineProperty2.default)(this, "dateFormat", this.props.getConfig('dateFormat'));
    (0, _defineProperty2.default)(this, "yAxisIdGenerator", (0, _eui.htmlIdGenerator)('yaxis'));
    (0, _defineProperty2.default)(this, "xAxisFormatter", interval => {
      const formatter = (0, _create_interval_based_formatter.createIntervalBasedFormatter)(interval, this.scaledDataFormat, this.dateFormat, this.props.model.ignore_daylight_time);
      return val => formatter(val);
    });
    (0, _defineProperty2.default)(this, "yAxisStackedByPercentFormatter", val => {
      const n = Number(val) * 100;
      return `${(Number.isNaN(n) ? 0 : n).toFixed(0)}%`;
    });
    (0, _defineProperty2.default)(this, "applyDocTo", template => doc => {
      const {
        fieldFormatMap
      } = this.props;

      // formatting each doc value with custom field formatter if fieldFormatMap contains that doc field name
      Object.keys(doc).forEach(fieldName => {
        if (fieldFormatMap !== null && fieldFormatMap !== void 0 && fieldFormatMap[fieldName]) {
          const valueFieldFormatter = (0, _create_field_formatter.createFieldFormatter)(fieldName, fieldFormatMap);
          doc[fieldName] = valueFieldFormatter(doc[fieldName]);
        }
      });
      const vars = (0, _replace_vars.replaceVars)(template, null, doc, {
        noEscape: true
      });
      if (vars instanceof Error) {
        this.showToastNotification = vars.error.caused_by;
        return template;
      }
      return vars;
    });
    (0, _defineProperty2.default)(this, "prepareAnnotations", () => {
      const {
        model,
        visData
      } = this.props;
      return (0, _lodash.map)(model.annotations, ({
        id,
        color,
        icon,
        template
      }) => {
        const annotationData = (0, _lodash.get)(visData, `${model.id}.annotations.${id}`, []);
        const applyDocToTemplate = this.applyDocTo(template);
        return {
          id,
          color,
          icon,
          data: annotationData.map(({
            docs,
            ...rest
          }) => ({
            ...rest,
            docs: docs.map(applyDocToTemplate)
          }))
        };
      });
    });
  }
  componentDidUpdate() {
    const toastNotifications = (0, _services.getCoreStart)().notifications.toasts;
    if (this.showToastNotification && this.notificationReason !== this.showToastNotification.reason) {
      if (this.notification) {
        toastNotifications.remove(this.notification);
      }
      this.notificationReason = this.showToastNotification.reason;
      this.notification = toastNotifications.addDanger({
        title: this.showToastNotification.title,
        text: /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
          readOnly: true
        }, this.showToastNotification.reason)
      });
    }
    if (!this.showToastNotification && this.notification) {
      toastNotifications.remove(this.notification);
      this.notificationReason = null;
      this.notification = null;
    }
  }
  render() {
    const {
      model,
      visData,
      onBrush,
      onFilterClick,
      syncColors,
      syncTooltips,
      syncCursor,
      palettesService,
      fieldFormatMap,
      getConfig,
      initialRender
    } = this.props;
    const series = (0, _lodash.get)(visData, `${model.id}.series`, []);
    const interval = (0, _get_interval.getInterval)(visData, model);
    const mainAxisGroupId = this.yAxisIdGenerator('main_group');
    const seriesModel = model.series.filter(s => !s.hidden).map(s => (0, _lodash.cloneDeep)(s));
    const mainAxisScaleType = TimeseriesVisualization.getAxisScaleType(model);
    const mainAxisDomain = TimeseriesVisualization.getYAxisDomain(model);
    const yAxis = [];
    let mainDomainAdded = false;
    this.showToastNotification = null;
    seriesModel.forEach(seriesGroup => {
      var _seriesGroup$palette;
      const isStackedWithinSeries = seriesGroup.stacked === _constants.STACKED_OPTIONS.STACKED_WITHIN_SERIES;
      const hasSeparateAxis = Boolean(seriesGroup.separate_axis);
      const groupId = hasSeparateAxis || isStackedWithinSeries ? seriesGroup.id : mainAxisGroupId;
      const domain = hasSeparateAxis ? TimeseriesVisualization.getYAxisDomain(seriesGroup) : undefined;
      const isCustomDomain = groupId !== mainAxisGroupId;
      const seriesGroupTickFormatter = seriesGroup.formatter === _enums.DATA_FORMATTERS.DEFAULT ? (0, _create_field_formatter.createFieldFormatter)((0, _get_metrics_field.getMetricsField)(seriesGroup.metrics), fieldFormatMap) : TimeseriesVisualization.getTickFormatter(seriesGroup, getConfig);
      const palette = {
        ...seriesGroup.palette,
        name: seriesGroup.split_color_mode === 'kibana' ? 'kibana_palette' : seriesGroup.split_color_mode || ((_seriesGroup$palette = seriesGroup.palette) === null || _seriesGroup$palette === void 0 ? void 0 : _seriesGroup$palette.name)
      };
      const yScaleType = hasSeparateAxis ? TimeseriesVisualization.getAxisScaleType(seriesGroup) : mainAxisScaleType;
      if (seriesGroup.stacked === _constants.STACKED_OPTIONS.PERCENT) {
        seriesGroup.separate_axis = true;
        seriesGroup.axisFormatter = 'percent';
        seriesGroup.axis_min = seriesGroup.axis_min || 0;
        seriesGroup.axis_max = seriesGroup.axis_max || 1;
        seriesGroup.axis_position = model.axis_position;
      }
      series.filter(r => (0, _lodash.startsWith)(r.id, seriesGroup.id)).forEach(seriesDataRow => {
        seriesDataRow.tickFormat = seriesGroupTickFormatter;
        seriesDataRow.groupId = groupId;
        seriesDataRow.yScaleType = yScaleType;
        seriesDataRow.hideInLegend = Boolean(seriesGroup.hide_in_legend);
        seriesDataRow.palette = palette;
        seriesDataRow.baseColor = seriesGroup.color;
        seriesDataRow.isSplitByTerms = seriesGroup.split_mode === 'terms';
      });
      if (isCustomDomain) {
        TimeseriesVisualization.addYAxis(yAxis, {
          domain,
          groupId,
          id: this.yAxisIdGenerator(seriesGroup.id),
          position: seriesGroup.axis_position,
          hide: isStackedWithinSeries,
          tickFormatter: seriesGroup.stacked === _constants.STACKED_OPTIONS.PERCENT ? this.yAxisStackedByPercentFormatter : seriesGroupTickFormatter
        });
      } else if (!mainDomainAdded) {
        const tickFormatter = (0, _check_if_series_have_same_formatters.checkIfSeriesHaveSameFormatters)(seriesModel, fieldFormatMap) ? seriesGroupTickFormatter : (0, _tick_formatter.createTickFormatter)(undefined, undefined, getConfig);
        TimeseriesVisualization.addYAxis(yAxis, {
          tickFormatter,
          id: this.yAxisIdGenerator('main'),
          groupId: mainAxisGroupId,
          position: model.axis_position,
          domain: mainAxisDomain
        });
        mainDomainAdded = true;
      }
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbVis"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbVisTimeSeries"
    }, /*#__PURE__*/_react.default.createElement(_timeseries.TimeSeries, {
      series: series,
      yAxis: yAxis,
      onBrush: onBrush,
      onFilterClick: onFilterClick,
      backgroundColor: model.background_color,
      showGrid: Boolean(model.show_grid),
      legend: Boolean(model.show_legend),
      legendPosition: model.legend_position,
      truncateLegend: Boolean(model.truncate_legend),
      ignoreDaylightTime: Boolean(model.ignore_daylight_time),
      maxLegendLines: model.max_lines_legend,
      tooltipMode: model.tooltip_mode,
      xAxisFormatter: this.xAxisFormatter(interval),
      annotations: this.prepareAnnotations(),
      syncColors: syncColors,
      syncTooltips: syncTooltips,
      syncCursor: syncCursor,
      palettesService: palettesService,
      interval: interval,
      initialRender: initialRender,
      useLegacyTimeAxis: getConfig(_common.LEGACY_TIME_AXIS, false),
      isLastBucketDropped: Boolean(model.drop_last_bucket || model.series.some(series => series.series_drop_last_bucket))
    })));
  }
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = TimeseriesVisualization;
(0, _defineProperty2.default)(TimeseriesVisualization, "propTypes", {
  model: _propTypes.default.object,
  onBrush: _propTypes.default.func,
  onFilterClick: _propTypes.default.func,
  visData: _propTypes.default.object,
  getConfig: _propTypes.default.func
});
(0, _defineProperty2.default)(TimeseriesVisualization, "getYAxisDomain", model => {
  const axisMin = (0, _lodash.get)(model, 'axis_min', '').toString();
  const axisMax = (0, _lodash.get)(model, 'axis_max', '').toString();
  const fit = model.series ? model.series.filter(({
    hidden
  }) => !hidden).every(({
    fill
  }) => Number(fill) === 0) : Number(model.fill) === 0;
  return {
    min: axisMin.length ? Number(axisMin) : undefined,
    max: axisMax.length ? Number(axisMax) : undefined,
    fit
  };
});
(0, _defineProperty2.default)(TimeseriesVisualization, "addYAxis", (yAxis, {
  id,
  groupId,
  position,
  tickFormatter,
  domain,
  hide
}) => {
  yAxis.push({
    id,
    groupId,
    position,
    tickFormatter,
    domain,
    hide
  });
});
(0, _defineProperty2.default)(TimeseriesVisualization, "getAxisScaleType", model => (0, _lodash.get)(model, 'axis_scale') === 'log' ? _charts.ScaleType.Log : _charts.ScaleType.Linear);
(0, _defineProperty2.default)(TimeseriesVisualization, "getTickFormatter", (model, getConfig) => (0, _tick_formatter.createTickFormatter)((0, _lodash.get)(model, 'formatter'), (0, _lodash.get)(model, 'value_template'), getConfig));
module.exports = exports.default;