"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireWildcard(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _url = require("url");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _get_metrics_field = require("../../lib/get_metrics_field");
var _tick_formatter = require("../../lib/tick_formatter");
var _create_field_formatter = require("../../lib/create_field_formatter");
var _is_sortable = require("./is_sortable");
var _eui = require("@elastic/eui");
var _replace_vars = require("../../lib/replace_vars");
var _external_url_error_modal = require("../../lib/external_url_error_modal");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../services");
var _enums = require("../../../../../common/enums");
var _common = require("@kbn/field-formats-plugin/common");
var _fields_utils = require("../../../../../common/fields_utils");
var _render_counter = require("../../render_counter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getColor(rules, colorKey, value) {
  let color;
  if (rules) {
    rules.forEach(rule => {
      if (rule.operator && rule.value != null) {
        if (_lodash.default[rule.operator](value, rule.value)) {
          color = rule[colorKey];
        }
      }
    });
  }
  return color;
}
function sanitizeUrl(url) {
  const {
    protocol
  } = (0, _url.parse)(url);
  // eslint-disable-next-line no-script-url
  if (protocol === 'javascript:' || protocol === 'data:' || protocol === 'vbscript:') {
    return '';
  }
  return url;
}
class TableVis extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "createDrilldownUrlClickHandler", url => event => {
      const validatedUrl = (0, _services.getCoreStart)().http.externalUrl.validateUrl(url);
      if (validatedUrl) {
        this.setState({
          accessDeniedDrilldownUrl: null
        });
      } else {
        event.preventDefault();
        this.setState({
          accessDeniedDrilldownUrl: url
        });
      }
    });
    (0, _defineProperty2.default)(this, "renderRow", (row, pivotIds, fieldValuesFormatter) => {
      const {
        model,
        fieldFormatMap,
        getConfig
      } = this.props;
      let rowDisplay = row.key;
      if (pivotIds.length) {
        rowDisplay = pivotIds.map((item, index) => {
          var _row$key;
          const value = [(_row$key = row.key) !== null && _row$key !== void 0 ? _row$key : null].flat()[index];
          const formatted = fieldValuesFormatter(item, value, 'html');

          // eslint-disable-next-line react/no-danger
          return /*#__PURE__*/_react.default.createElement("span", {
            dangerouslySetInnerHTML: {
              __html: formatted !== null && formatted !== void 0 ? formatted : value
            }
          });
        }).reduce((prev, curr) => [prev, _fields_utils.MULTI_FIELD_VALUES_SEPARATOR, curr]);
      }
      if (model.drilldown_url) {
        const url = (0, _replace_vars.replaceVars)(model.drilldown_url, {}, {
          key: row.key
        }, {
          noEscape: true
        });
        const handleDrilldownUrlClick = this.createDrilldownUrlClickHandler(url);
        rowDisplay = /*#__PURE__*/_react.default.createElement("a", {
          href: sanitizeUrl(url),
          onClick: handleDrilldownUrlClick,
          onContextMenu: handleDrilldownUrlClick
        }, rowDisplay);
      }
      const columns = row.series.filter(item => item).map(item => {
        var _column$color_rules;
        const column = this.visibleSeries.find(c => c.id === item.id);
        if (!column) return null;
        const hasColorRules = (_column$color_rules = column.color_rules) === null || _column$color_rules === void 0 ? void 0 : _column$color_rules.some(({
          value,
          operator,
          text
        }) => value || operator || text);
        const formatter = column.formatter === _enums.DATA_FORMATTERS.DEFAULT ? (0, _create_field_formatter.createFieldFormatter)((0, _get_metrics_field.getMetricsField)(column.metrics), fieldFormatMap, 'html', hasColorRules) : (0, _tick_formatter.createTickFormatter)(column.formatter, column.value_template, getConfig);
        const value = formatter(item.last);
        let trend;
        if (column.trend_arrows) {
          const trendIcon = item.slope > 0 ? 'sortUp' : 'sortDown';
          trend = /*#__PURE__*/_react.default.createElement("span", null, "\xA0 ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: trendIcon,
            color: "subdued"
          }));
        }
        const style = {
          color: getColor(column.color_rules, 'text', item.last)
        };
        return /*#__PURE__*/_react.default.createElement("td", {
          key: `${row.key}-${item.id}`,
          "data-test-subj": "tvbTableVis__value",
          className: "eui-textRight",
          style: style
        }, /*#__PURE__*/_react.default.createElement("span", {
          dangerouslySetInnerHTML: {
            __html: value
          }
        }), trend);
      });
      return /*#__PURE__*/_react.default.createElement("tr", {
        key: row.key
      }, /*#__PURE__*/_react.default.createElement("td", null, rowDisplay), columns);
    });
    (0, _defineProperty2.default)(this, "closeExternalUrlErrorModal", () => this.setState({
      accessDeniedDrilldownUrl: null
    }));
    this.fieldFormatsService = (0, _services.getFieldFormats)();
    this.state = {
      accessDeniedDrilldownUrl: null
    };
  }
  get visibleSeries() {
    return (0, _lodash.get)(this.props, 'model.series', []).filter(series => !series.hidden);
  }
  renderHeader(pivotIds) {
    const {
      model,
      uiState,
      onUiState,
      visData
    } = this.props;
    const stateKey = `${model.type}.sort`;
    const sort = uiState.get(stateKey, {
      column: '_default_',
      order: 'asc'
    });
    const calculateHeaderLabel = (metric, item) => {
      var _visData$series$, _visData$series$$seri, _visData$series$$seri2;
      return item.label || ((_visData$series$ = visData.series[0]) === null || _visData$series$ === void 0 ? void 0 : (_visData$series$$seri = _visData$series$.series) === null || _visData$series$$seri === void 0 ? void 0 : (_visData$series$$seri2 = _visData$series$$seri.find(s => item.id === s.id)) === null || _visData$series$$seri2 === void 0 ? void 0 : _visData$series$$seri2.label);
    };
    const columns = this.visibleSeries.map(item => {
      const metric = (0, _lodash.last)(item.metrics);
      const label = calculateHeaderLabel(metric, item);
      const handleClick = () => {
        if (!(0, _is_sortable.isSortable)(metric)) return;
        let order;
        if (sort.column === item.id) {
          order = sort.order === 'asc' ? 'desc' : 'asc';
        } else {
          order = 'asc';
        }
        onUiState(stateKey, {
          column: item.id,
          order
        });
      };
      let sortComponent;
      if ((0, _is_sortable.isSortable)(metric)) {
        let sortIcon;
        if (sort.column === item.id) {
          sortIcon = sort.order === 'asc' ? 'sortUp' : 'sortDown';
        } else {
          sortIcon = 'empty';
        }
        sortComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: sortIcon
        });
      }
      let headerContent = /*#__PURE__*/_react.default.createElement("span", null, label, " ", sortComponent);
      if (!(0, _is_sortable.isSortable)(metric)) {
        headerContent = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "visTypeTimeseries.table.columnNotSortableTooltip",
            defaultMessage: "This column is not sortable"
          })
        }, headerContent);
      }
      return /*#__PURE__*/_react.default.createElement("th", {
        onClick: handleClick,
        key: item.id,
        scope: "col"
      }, headerContent);
    });
    const label = visData.pivot_label || model.pivot_label || (0, _fields_utils.getMultiFieldLabel)(pivotIds);
    let sortIcon;
    if (sort.column === '_default_') {
      sortIcon = sort.order === 'asc' ? 'sortUp' : 'sortDown';
    } else {
      sortIcon = 'empty';
    }
    const sortComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: sortIcon
    });
    const handleSortClick = () => {
      let order;
      if (sort.column === '_default_') {
        order = sort.order === 'asc' ? 'desc' : 'asc';
      } else {
        order = 'asc';
      }
      onUiState(stateKey, {
        column: '_default_',
        order
      });
    };
    return /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("th", {
      className: "eui-textLeft",
      scope: "col",
      onClick: handleSortClick
    }, label, " ", sortComponent), columns);
  }
  render() {
    var _model$pivot_type;
    const {
      visData,
      model,
      indexPattern,
      initialRender
    } = this.props;
    const {
      accessDeniedDrilldownUrl
    } = this.state;
    const fields = (model.pivot_type ? [(_model$pivot_type = model.pivot_type) !== null && _model$pivot_type !== void 0 ? _model$pivot_type : null].flat() : []).map((type, index) => {
      var _model$pivot_id;
      return {
        name: [(_model$pivot_id = model.pivot_id) !== null && _model$pivot_id !== void 0 ? _model$pivot_id : null].flat()[index],
        type
      };
    });
    const fieldValuesFormatter = (0, _fields_utils.createCachedFieldValueFormatter)(indexPattern, fields, this.fieldFormatsService, undefined, model.drilldown_url ? [_common.FIELD_FORMAT_IDS.URL] : []);
    const pivotIds = (0, _fields_utils.getFieldsForTerms)(model.pivot_id);
    const header = this.renderHeader(pivotIds);
    let rows = null;
    if ((0, _lodash.isArray)(visData.series) && visData.series.length) {
      rows = visData.series.map(item => this.renderRow(item, pivotIds, fieldValuesFormatter));
    }
    return /*#__PURE__*/_react.default.createElement(_render_counter.RenderCounter, {
      initialRender: initialRender
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: (0, _services.getCoreStart)(),
      className: "tvbVis",
      "data-test-subj": "tableView"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbVis",
      "data-test-subj": "tableView"
    }, /*#__PURE__*/_react.default.createElement("table", {
      className: "table"
    }, /*#__PURE__*/_react.default.createElement("thead", null, header), /*#__PURE__*/_react.default.createElement("tbody", null, rows)))), accessDeniedDrilldownUrl && /*#__PURE__*/_react.default.createElement(_external_url_error_modal.ExternalUrlErrorModal, {
      url: accessDeniedDrilldownUrl,
      handleClose: this.closeExternalUrlErrorModal
    }));
  }
}
exports.default = TableVis;
TableVis.defaultProps = {
  sort: {}
};
TableVis.propTypes = {
  visData: _propTypes.default.object,
  model: _propTypes.default.object,
  backgroundColor: _propTypes.default.string,
  onPaginate: _propTypes.default.func,
  onUiState: _propTypes.default.func,
  uiState: _propTypes.default.object,
  pageNumber: _propTypes.default.number,
  getConfig: _propTypes.default.func,
  indexPattern: _propTypes.default.object
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;