"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSeries = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _add_delete_buttons = require("../../add_delete_buttons");
var _config = require("./config");
var _series_drag_handler = require("../../series_drag_handler");
var _eui = require("@elastic/eui");
var _create_text_handler = require("../../lib/create_text_handler");
var _i18nReact = require("@kbn/i18n-react");
var _aggs = require("../../aggs/aggs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TableSeriesUI(props) {
  const {
    model,
    onAdd,
    name,
    fields,
    panel,
    onChange,
    onDelete,
    disableDelete,
    disableAdd,
    selectedTab,
    visible,
    intl,
    uiRestrictions
  } = props;
  const handleChange = (0, _create_text_handler.createTextHandler)(onChange);
  let caretIcon = 'arrowDown';
  if (!visible) caretIcon = 'arrowRight';
  let body = null;
  if (visible) {
    let seriesBody;
    if (selectedTab === 'metrics') {
      seriesBody = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_aggs.Aggs, {
        onChange: props.onChange,
        fields: fields,
        panel: panel,
        model: model,
        name: name,
        uiRestrictions: uiRestrictions,
        dragHandleProps: props.dragHandleProps
      }));
    } else {
      seriesBody = /*#__PURE__*/_react.default.createElement(_config.TableSeriesConfig, {
        panel: props.panel,
        fields: props.fields,
        model: props.model,
        onChange: props.onChange,
        indexPatternForQuery: props.indexPatternForQuery,
        uiRestrictions: props.uiRestrictions
      });
    }
    body = /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbSeries__body"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === 'metrics',
      onClick: () => props.switchTab('metrics')
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.table.tab.metricsLabel",
      defaultMessage: "Metrics"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      "data-test-subj": "seriesOptions",
      isSelected: selectedTab === 'options',
      onClick: () => props.switchTab('options')
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.table.tab.optionsLabel",
      defaultMessage: "Options"
    }))), seriesBody);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `${props.className}`,
    style: props.style
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: caretIcon,
    color: "text",
    onClick: props.toggleVisible,
    "aria-label": intl.formatMessage({
      id: 'visTypeTimeseries.table.toggleSeriesEditorAriaLabel',
      defaultMessage: 'Toggle series editor'
    }),
    "aria-expanded": props.visible
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    "aria-label": intl.formatMessage({
      id: 'visTypeTimeseries.table.labelAriaLabel',
      defaultMessage: 'Label'
    }),
    onChange: handleChange('label'),
    placeholder: intl.formatMessage({
      id: 'visTypeTimeseries.table.labelPlaceholder',
      defaultMessage: 'Label'
    }),
    value: model.label
  })), /*#__PURE__*/_react.default.createElement(_series_drag_handler.SeriesDragHandler, {
    dragHandleProps: props.dragHandleProps,
    hideDragHandler: props.disableDelete
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
    addTooltip: intl.formatMessage({
      id: 'visTypeTimeseries.table.addSeriesTooltip',
      defaultMessage: 'Add Series'
    }),
    deleteTooltip: intl.formatMessage({
      id: 'visTypeTimeseries.table.deleteSeriesTooltip',
      defaultMessage: 'Delete Series'
    }),
    cloneTooltip: intl.formatMessage({
      id: 'visTypeTimeseries.table.cloneSeriesTooltip',
      defaultMessage: 'Clone Series'
    }),
    onDelete: onDelete,
    onClone: props.onClone,
    onAdd: onAdd,
    togglePanelActivation: props.togglePanelActivation,
    isPanelActive: !model.hidden,
    disableDelete: disableDelete,
    disableAdd: disableAdd,
    responsive: false
  }))), body);
}
TableSeriesUI.propTypes = {
  className: _propTypes.default.string,
  disableAdd: _propTypes.default.bool,
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  name: _propTypes.default.string,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onClone: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  model: _propTypes.default.object,
  panel: _propTypes.default.object,
  selectedTab: _propTypes.default.string,
  style: _propTypes.default.object,
  switchTab: _propTypes.default.func,
  toggleVisible: _propTypes.default.func,
  visible: _propTypes.default.bool,
  togglePanelActivation: _propTypes.default.func,
  uiRestrictions: _propTypes.default.object,
  dragHandleProps: _propTypes.default.object,
  indexPatternForQuery: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string])
};
const TableSeries = exports.TableSeries = (0, _i18nReact.injectI18n)(TableSeriesUI);