"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateReInterval = exports.unitLookup = exports.isGteInterval = exports.isAutoInterval = exports.getInterval = exports.convertIntervalIntoUnit = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/data-plugin/public");
var _interval_regexp = require("../../../../common/interval_regexp");
var _constants = require("../../../../common/constants");
var _vis_data_utils = require("../../../../common/vis_data_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  parseEsInterval
} = _public.search.aggs;
const unitLookup = exports.unitLookup = {
  s: _i18n.i18n.translate('visTypeTimeseries.getInterval.secondsLabel', {
    defaultMessage: 'seconds'
  }),
  m: _i18n.i18n.translate('visTypeTimeseries.getInterval.minutesLabel', {
    defaultMessage: 'minutes'
  }),
  h: _i18n.i18n.translate('visTypeTimeseries.getInterval.hoursLabel', {
    defaultMessage: 'hours'
  }),
  d: _i18n.i18n.translate('visTypeTimeseries.getInterval.daysLabel', {
    defaultMessage: 'days'
  }),
  w: _i18n.i18n.translate('visTypeTimeseries.getInterval.weeksLabel', {
    defaultMessage: 'weeks'
  }),
  M: _i18n.i18n.translate('visTypeTimeseries.getInterval.monthsLabel', {
    defaultMessage: 'months'
  }),
  y: _i18n.i18n.translate('visTypeTimeseries.getInterval.yearsLabel', {
    defaultMessage: 'years'
  })
};
const convertIntervalIntoUnit = (interval, hasTranslateUnitString = true) => {
  // Iterate units from biggest to smallest
  const units = Object.keys(unitLookup).reverse();
  const duration = _moment.default.duration(interval, 'ms');
  for (let i = 0; i < units.length; i++) {
    const as = duration.as(units[i]);
    if (Math.abs(as) > 1) {
      return {
        unitValue: Math.round(Math.abs(as)),
        unitString: hasTranslateUnitString ? unitLookup[units[i]] : units[i]
      };
    }
  }
};
exports.convertIntervalIntoUnit = convertIntervalIntoUnit;
const isGteInterval = interval => _interval_regexp.GTE_INTERVAL_RE.test(interval);
exports.isGteInterval = isGteInterval;
const isAutoInterval = interval => !interval || interval === _constants.AUTO_INTERVAL;
exports.isAutoInterval = isAutoInterval;
const validateReInterval = intervalValue => {
  const validationResult = {};
  try {
    parseEsInterval(intervalValue);
  } catch ({
    message
  }) {
    validationResult.errorMessage = message;
  } finally {
    validationResult.isValid = !validationResult.errorMessage;
  }
  return validationResult;
};
exports.validateReInterval = validateReInterval;
const getInterval = (visData, model) => {
  const series = (0, _lodash.get)(visData, (0, _vis_data_utils.isVisTableData)(visData) ? `series[0].series` : `${model.id}.series`, []);
  return series.reduce((currentInterval, item) => {
    if (item.data.length > 1 && typeof item.data[1][0] === 'number' && typeof item.data[0][0] === 'number') {
      const seriesInterval = item.data[1][0] - item.data[0][0];
      if (!currentInterval || seriesInterval < currentInterval) return seriesInterval;
    }
    return currentInterval;
  }, 0);
};
exports.getInterval = getInterval;