"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFieldFormatter = void 0;
var _lodash = require("lodash");
var _common = require("@kbn/field-formats-plugin/common");
var _last_value_utils = require("../../../../common/last_value_utils");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createFieldFormatter = (fieldName = '', fieldFormatMap, contextType, hasColorRules = false, dataView) => {
  var _dataView$getFieldByN;
  const serializedFieldFormat = fieldFormatMap === null || fieldFormatMap === void 0 ? void 0 : fieldFormatMap[fieldName];
  // field formatting should be skipped either there's no such field format in fieldFormatMap
  // or it's color formatting and color rules are already applied
  const shouldSkipFormatting = !serializedFieldFormat || hasColorRules && (serializedFieldFormat === null || serializedFieldFormat === void 0 ? void 0 : serializedFieldFormat.id) === _common.FIELD_FORMAT_IDS.COLOR;
  const fieldType = (dataView === null || dataView === void 0 ? void 0 : (_dataView$getFieldByN = dataView.getFieldByName(fieldName)) === null || _dataView$getFieldByN === void 0 ? void 0 : _dataView$getFieldByN.type) || 'number';
  const defaultFieldFormat = fieldType === 'date' ? {
    id: 'date'
  } : fieldType === 'string' ? {
    id: 'string'
  } : fieldType === 'boolean' ? {
    id: 'boolean'
  } : {
    id: 'number'
  };
  const fieldFormat = (0, _services.getFieldFormats)().deserialize(shouldSkipFormatting ? defaultFieldFormat : serializedFieldFormat);
  return value => {
    if ((0, _last_value_utils.isEmptyValue)(value)) {
      return _last_value_utils.DISPLAY_EMPTY_VALUE;
    }
    return fieldType !== 'number' || (0, _lodash.isNumber)(value) || !shouldSkipFormatting ? fieldFormat.convert(value, contextType) : value;
  };
};
exports.createFieldFormatter = createFieldFormatter;