"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collectionActions = void 0;
exports.handleAdd = handleAdd;
exports.handleChange = handleChange;
exports.handleDelete = handleDelete;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const newFn = () => ({
  id: (0, _uuid.v4)()
});
function handleChange(props, doc) {
  const {
    model,
    name
  } = props;
  const collection = model[name] || [];
  const part = {
    [name]: collection.map(row => row.id === doc.id ? doc : row)
  };
  props.onChange({
    ...model,
    ...part
  });
}
function handleDelete(props, doc) {
  var _props$onChange;
  const {
    model,
    name
  } = props;
  const collection = model[name] || [];
  const part = {
    [name]: collection.filter(row => row.id !== doc.id)
  };
  (_props$onChange = props.onChange) === null || _props$onChange === void 0 ? void 0 : _props$onChange.call(props, {
    ...model,
    ...part
  });
}
function handleAdd(props, fn = newFn) {
  var _props$onChange2;
  const {
    model,
    name
  } = props;
  const collection = model[name] || [];
  const part = {
    [name]: collection.concat([fn()])
  };
  (_props$onChange2 = props.onChange) === null || _props$onChange2 === void 0 ? void 0 : _props$onChange2.call(props, {
    ...model,
    ...part
  });
}
const collectionActions = exports.collectionActions = {
  handleAdd,
  handleDelete,
  handleChange
};