"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withStaticPadding = exports.validateLegendPositionValue = exports.extractAllYAxis = exports.createTickFormat = exports.MAIN_GROUP_ID = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _charts = require("@elastic/charts");
var _lib = require("../../common/lib");
var _xaxis_formatter = require("./xaxis_formatter");
var _tick_formatters = require("./tick_formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const validateLegendPositionValue = position => /^(n|s)(e|w)$/s.test(position);
exports.validateLegendPositionValue = validateLegendPositionValue;
const createTickFormat = (intervalValue, timefilter, uiSettings) => {
  // Get the X-axis tick format
  const time = timefilter.getBounds();
  const interval = (0, _lib.calculateInterval)(time.min && time.min.valueOf() || 0, time.max && time.max.valueOf() || 0, uiSettings.get('timelion:target_buckets') || 200, intervalValue, uiSettings.get('timelion:min_interval') || '1ms');
  const format = (0, _xaxis_formatter.xaxisFormatterProvider)(uiSettings)(interval);
  return val => (0, _momentTimezone.default)(val).format(format);
};

/** While we support 2 versions of the timeline, we need this adapter. **/
exports.createTickFormat = createTickFormat;
const MAIN_GROUP_ID = exports.MAIN_GROUP_ID = 1;
const withStaticPadding = domain => ({
  ...domain,
  padding: 20,
  paddingUnit: 'pixel'
});
exports.withStaticPadding = withStaticPadding;
const adaptYaxisParams = yaxis => {
  var _y$min, _y$max;
  const y = {
    ...yaxis
  };
  if (y.units) {
    const formatters = (0, _tick_formatters.tickFormatters)(y);
    y.tickFormatter = formatters[y.units.type];
  } else if (yaxis.tickDecimals) {
    y.tickFormatter = val => val.toFixed(yaxis.tickDecimals);
  }
  return {
    title: y.axisLabel,
    position: y.position,
    tickFormat: y.tickFormatter,
    domain: withStaticPadding({
      fit: y.min === undefined && y.max === undefined,
      min: (_y$min = y.min) !== null && _y$min !== void 0 ? _y$min : NaN,
      max: (_y$max = y.max) !== null && _y$max !== void 0 ? _y$max : NaN
    })
  };
};
const extractYAxisForSeries = series => {
  var _series$_global$yaxes, _series$_global;
  const yaxis = ((_series$_global$yaxes = (_series$_global = series._global) === null || _series$_global === void 0 ? void 0 : _series$_global.yaxes) !== null && _series$_global$yaxes !== void 0 ? _series$_global$yaxes : []).reduce((acc, item) => ({
    ...acc,
    ...item
  }), {});
  if (Object.keys(yaxis).length) {
    return adaptYaxisParams(yaxis);
  }
};
const extractAllYAxis = series => {
  return series.reduce((acc, data, index) => {
    const yaxis = extractYAxisForSeries(data);
    const groupId = `${data.yaxis ? data.yaxis : MAIN_GROUP_ID}`;
    if (acc.every(axis => axis.groupId !== groupId)) {
      acc.push({
        groupId,
        domain: withStaticPadding({
          fit: false,
          min: NaN,
          max: NaN
        }),
        id: ((yaxis === null || yaxis === void 0 ? void 0 : yaxis.position) || _charts.Position.Left) + index,
        position: _charts.Position.Left,
        ...yaxis
      });
    } else if (yaxis) {
      const axisOptionIndex = acc.findIndex(axis => axis.groupId === groupId);
      acc[axisOptionIndex] = {
        ...acc[axisOptionIndex],
        ...yaxis
      };
    }
    return acc;
  }, []);
};
exports.extractAllYAxis = extractAllYAxis;