"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TagCloudOptions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _collections = require("./collections");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TagCloudOptions({
  stateParams,
  setValue,
  palettes
}) {
  const [palettesRegistry, setPalettesRegistry] = (0, _react.useState)(undefined);
  const handleFontSizeChange = ([minFontSize, maxFontSize]) => {
    setValue('minFontSize', Number(minFontSize));
    setValue('maxFontSize', Number(maxFontSize));
  };
  const fontSizeRangeLabel = _i18n.i18n.translate('visTypeTagCloud.visParams.fontSizeLabel', {
    defaultMessage: 'Font size range in pixels'
  });
  (0, _react.useEffect)(() => {
    const fetchPalettes = async () => {
      const palettesService = await (palettes === null || palettes === void 0 ? void 0 : palettes.getPalettes());
      setPalettesRegistry(palettesService);
    };
    fetchPalettes();
  }, [palettes]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeTagCloud.visParams.textScaleLabel', {
      defaultMessage: 'Text scale'
    }),
    options: _collections.collections.scales,
    paramName: "scale",
    value: stateParams.scale,
    setValue: setValue
  }), palettesRegistry && /*#__PURE__*/_react.default.createElement(_public.PalettePicker, {
    palettes: palettesRegistry,
    activePalette: stateParams.palette,
    paramName: "palette",
    setPalette: (paramName, value) => {
      setValue(paramName, value);
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeTagCloud.visParams.orientationsLabel', {
      defaultMessage: 'Orientations'
    }),
    options: _collections.collections.orientations,
    paramName: "orientation",
    value: stateParams.orientation,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_public2.ValidatedDualRange, {
    allowEmptyRange: false,
    "aria-label": fontSizeRangeLabel,
    compressed: true,
    fullWidth: true,
    label: fontSizeRangeLabel,
    max: 100,
    min: 1,
    value: [stateParams.minFontSize, stateParams.maxFontSize],
    onChange: handleFontSizeChange,
    showInput: true
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeTagCloud.visParams.showLabelToggleLabel', {
      defaultMessage: 'Show label'
    }),
    paramName: "showLabel",
    value: stateParams.showLabel,
    setValue: setValue
  }));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;