"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expressions-plugin/public");
var _common = require("@kbn/expression-partition-vis-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const prepareDimension = params => {
  const visdimension = (0, _public2.buildExpressionFunction)('visdimension', {
    accessor: params.accessor
  });
  if (params.format) {
    visdimension.addArgument('format', params.format.id);
    visdimension.addArgument('formatParams', JSON.stringify(params.format.params));
  }
  return (0, _public2.buildExpression)([visdimension]);
};
const preparePalette = palette => {
  const paletteExpressionFunction = (0, _public2.buildExpressionFunction)('system_palette', {
    name: palette === null || palette === void 0 ? void 0 : palette.name
  });
  return (0, _public2.buildExpression)([paletteExpressionFunction]);
};
const prepareLabels = params => {
  const pieLabels = (0, _public2.buildExpressionFunction)(_common.PARTITION_LABELS_FUNCTION, {
    show: params.show,
    last_level: params.last_level,
    values: params.values,
    truncate: params.truncate
  });
  if (params.position) {
    pieLabels.addArgument('position', params.position);
  }
  if (params.valuesFormat) {
    pieLabels.addArgument('valuesFormat', params.valuesFormat);
  }
  if (params.percentDecimals != null) {
    pieLabels.addArgument('percentDecimals', params.percentDecimals);
  }
  return (0, _public2.buildExpression)([pieLabels]);
};
const toExpressionAst = async (vis, params) => {
  var _vis$params$nestedLeg, _vis$params$isDonut, _schemas$segment, _schemas$split_column, _schemas$split_row;
  const schemas = (0, _public.getVisSchemas)(vis, params);
  const args = {
    // explicitly pass each param to prevent extra values trapping
    addTooltip: vis.params.addTooltip,
    legendDisplay: vis.params.legendDisplay,
    legendPosition: vis.params.legendPosition,
    nestedLegend: (_vis$params$nestedLeg = vis.params.nestedLegend) !== null && _vis$params$nestedLeg !== void 0 ? _vis$params$nestedLeg : false,
    truncateLegend: vis.params.truncateLegend,
    maxLegendLines: vis.params.maxLegendLines,
    legendSize: vis.params.legendSize,
    distinctColors: vis.params.distinctColors,
    isDonut: (_vis$params$isDonut = vis.params.isDonut) !== null && _vis$params$isDonut !== void 0 ? _vis$params$isDonut : false,
    emptySizeRatio: vis.params.emptySizeRatio,
    palette: preparePalette(vis.params.palette),
    labels: prepareLabels(vis.params.labels),
    metrics: prepareDimension(schemas.metric[schemas.metric.length - 1]),
    buckets: (_schemas$segment = schemas.segment) === null || _schemas$segment === void 0 ? void 0 : _schemas$segment.map(prepareDimension),
    splitColumn: (_schemas$split_column = schemas.split_column) === null || _schemas$split_column === void 0 ? void 0 : _schemas$split_column.map(prepareDimension),
    splitRow: (_schemas$split_row = schemas.split_row) === null || _schemas$split_row === void 0 ? void 0 : _schemas$split_row.map(prepareDimension),
    startFromSecondLargestSlice: false
  };
  const visTypePie = (0, _public2.buildExpressionFunction)(_common.PIE_VIS_EXPRESSION_NAME, args);
  const ast = (0, _public2.buildExpression)([visTypePie]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;