"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValuesFormats = exports.getLabelPositions = exports.emptySizeRatioOptions = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/expression-partition-vis-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getLabelPositions = exports.getLabelPositions = [{
  text: _i18n.i18n.translate('visTypePie.labelPositions.insideText', {
    defaultMessage: 'Inside'
  }),
  value: _common.LabelPositions.INSIDE
}, {
  text: _i18n.i18n.translate('visTypePie.labelPositions.insideOrOutsideText', {
    defaultMessage: 'Inside or outside'
  }),
  value: _common.LabelPositions.DEFAULT
}];
const getValuesFormats = exports.getValuesFormats = [{
  text: _i18n.i18n.translate('visTypePie.valuesFormats.percent', {
    defaultMessage: 'Show percent'
  }),
  value: _common.ValueFormats.PERCENT
}, {
  text: _i18n.i18n.translate('visTypePie.valuesFormats.value', {
    defaultMessage: 'Show value'
  }),
  value: _common.ValueFormats.VALUE
}];
const emptySizeRatioOptions = exports.emptySizeRatioOptions = [{
  id: 'emptySizeRatioOption-small',
  value: _common.EmptySizeRatios.SMALL,
  label: _i18n.i18n.translate('visTypePie.emptySizeRatioOptions.small', {
    defaultMessage: 'Small'
  })
}, {
  id: 'emptySizeRatioOption-medium',
  value: _common.EmptySizeRatios.MEDIUM,
  label: _i18n.i18n.translate('visTypePie.emptySizeRatioOptions.medium', {
    defaultMessage: 'Medium'
  })
}, {
  id: 'emptySizeRatioOption-large',
  value: _common.EmptySizeRatios.LARGE,
  label: _i18n.i18n.translate('visTypePie.emptySizeRatioOptions.large', {
    defaultMessage: 'Large'
  })
}];