"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = void 0;
var _common = require("@kbn/expression-partition-vis-plugin/common");
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getLayers = (layerId, vis, metrics, buckets) => {
  var _ref, _vis$params$labels$va, _vis$params$labels$va2, _vis$params$labels$po, _ref2, _vis$params$legendPos, _vis$params$nestedLeg, _vis$params$labels$pe, _vis$params$emptySize, _vis$params$maxLegend, _vis$params$legendSiz, _vis$params$truncateL;
  const legendOpen = vis.uiState.get('vis.legendOpen');
  const legendDisplayFromUiState = legendOpen !== undefined ? legendOpen ? _common.LegendDisplay.SHOW : _common.LegendDisplay.HIDE : undefined;
  const showValuesInLegend = (_ref = (_vis$params$labels$va = vis.params.labels.values) !== null && _vis$params$labels$va !== void 0 ? _vis$params$labels$va : vis.params.showValuesInLegend) !== null && _ref !== void 0 ? _ref : vis.type.visConfig.defaults.showValuesInLegend;
  return [{
    layerId,
    layerType: 'data',
    primaryGroups: buckets,
    secondaryGroups: [],
    metrics: metrics.length ? [metrics[0]] : [],
    numberDisplay: showValuesInLegend === false ? _convert_to_lens.NumberDisplayTypes.HIDDEN : (_vis$params$labels$va2 = vis.params.labels.valuesFormat) !== null && _vis$params$labels$va2 !== void 0 ? _vis$params$labels$va2 : vis.type.visConfig.defaults.labels.valuesFormat,
    categoryDisplay: vis.params.labels.show ? (_vis$params$labels$po = vis.params.labels.position) !== null && _vis$params$labels$po !== void 0 ? _vis$params$labels$po : vis.type.visConfig.defaults.labels.position : _convert_to_lens.CategoryDisplayTypes.HIDE,
    legendDisplay: (_ref2 = legendDisplayFromUiState !== null && legendDisplayFromUiState !== void 0 ? legendDisplayFromUiState : vis.params.legendDisplay) !== null && _ref2 !== void 0 ? _ref2 : vis.type.visConfig.defaults.legendDisplay,
    legendPosition: (_vis$params$legendPos = vis.params.legendPosition) !== null && _vis$params$legendPos !== void 0 ? _vis$params$legendPos : vis.type.visConfig.defaults.legendPosition,
    showValuesInLegend,
    nestedLegend: (_vis$params$nestedLeg = vis.params.nestedLegend) !== null && _vis$params$nestedLeg !== void 0 ? _vis$params$nestedLeg : vis.type.visConfig.defaults.nestedLegend,
    percentDecimals: (_vis$params$labels$pe = vis.params.labels.percentDecimals) !== null && _vis$params$labels$pe !== void 0 ? _vis$params$labels$pe : vis.type.visConfig.defaults.labels.percentDecimals,
    emptySizeRatio: (_vis$params$emptySize = vis.params.emptySizeRatio) !== null && _vis$params$emptySize !== void 0 ? _vis$params$emptySize : vis.type.visConfig.defaults.emptySizeRatio,
    legendMaxLines: (_vis$params$maxLegend = vis.params.maxLegendLines) !== null && _vis$params$maxLegend !== void 0 ? _vis$params$maxLegend : vis.type.visConfig.defaults.maxLegendLines,
    legendSize: (_vis$params$legendSiz = vis.params.legendSize) !== null && _vis$params$legendSiz !== void 0 ? _vis$params$legendSiz : vis.type.visConfig.defaults.legendSize,
    truncateLegend: (_vis$params$truncateL = vis.params.truncateLegend) !== null && _vis$params$truncateL !== void 0 ? _vis$params$truncateL : vis.type.visConfig.defaults.truncateLegend
  }];
};
const getConfiguration = (layerId, vis, {
  metrics,
  buckets
}) => {
  return {
    shape: vis.params.isDonut ? 'donut' : 'pie',
    layers: getLayers(layerId, vis, metrics, buckets.all),
    palette: vis.params.palette
  };
};
exports.getConfiguration = getConfiguration;