"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialWidth = exports.DefaultEditorSize = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let DefaultEditorSize = exports.DefaultEditorSize = /*#__PURE__*/function (DefaultEditorSize) {
  DefaultEditorSize["SMALL"] = "small";
  DefaultEditorSize["MEDIUM"] = "medium";
  DefaultEditorSize["LARGE"] = "large";
  return DefaultEditorSize;
}({});
const getInitialWidth = size => {
  switch (size) {
    case DefaultEditorSize.SMALL:
      return 15;
    case DefaultEditorSize.LARGE:
      return 50;
    case DefaultEditorSize.MEDIUM:
    default:
      return 30;
  }
};
exports.getInitialWidth = getInitialWidth;