"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorSchemaOptions = ColorSchemaOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _select = require("./select");
var _switch = require("./switch");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ColorSchemaOptions({
  disabled,
  colorSchema,
  colorSchemas,
  invertColors,
  uiState,
  setValue,
  showHelpText = true
}) {
  const [isCustomColors, setIsCustomColors] = (0, _react.useState)(() => !!uiState.get('vis.colors'));
  (0, _react.useEffect)(() => {
    uiState.on('colorChanged', () => {
      setIsCustomColors(true);
    });
  }, [uiState]);
  const resetColorsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      uiState.set('vis.colors', null);
      uiState === null || uiState === void 0 ? void 0 : uiState.emit('reload');
      setIsCustomColors(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.options.colorSchema.resetColorsButtonLabel",
    defaultMessage: "Reset colors"
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_select.SelectOption, {
    disabled: disabled,
    helpText: showHelpText && _i18n.i18n.translate('visDefaultEditor.options.colorSchema.howToChangeColorsDescription', {
      defaultMessage: 'Individual colors can be changed in the legend.'
    }),
    label: _i18n.i18n.translate('visDefaultEditor.options.colorSchema.colorSchemaLabel', {
      defaultMessage: 'Color schema'
    }),
    labelAppend: isCustomColors && resetColorsButton,
    options: colorSchemas,
    paramName: "colorSchema",
    value: colorSchema,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_switch.SwitchOption, {
    disabled: disabled,
    label: _i18n.i18n.translate('visDefaultEditor.options.colorSchema.reverseColorSchemaLabel', {
      defaultMessage: 'Reverse schema'
    }),
    paramName: "invertColors",
    value: invertColors,
    setValue: setValue
  }));
}