"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopAggregateParamEditor = TopAggregateParamEditor;
exports.getCompatibleAggs = getCompatibleAggs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getCompatibleAggs(agg) {
  const {
    options = []
  } = agg.getAggParams().find(({
    name
  }) => name === 'aggregate');
  return options.filter(option => option.isCompatible(agg));
}
function TopAggregateParamEditor({
  agg,
  aggParam,
  value,
  showValidation,
  setValue,
  setValidity,
  setTouched
}) {
  const isFirstRun = (0, _react.useRef)(true);
  const fieldType = agg.params.field && agg.params.field.type;
  const emptyValue = {
    text: '',
    value: 'EMPTY_VALUE',
    disabled: true,
    hidden: true
  };
  const filteredOptions = getCompatibleAggs(agg).map(({
    text,
    value: val
  }) => ({
    text,
    value: val
  })).sort((a, b) => a.text.toLowerCase().localeCompare(b.text.toLowerCase()));
  const options = [emptyValue, ...filteredOptions];
  const disabled = fieldType && !filteredOptions.length;
  const isValid = disabled || !!value;
  const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.aggregateWithLabel",
    defaultMessage: "Aggregate with"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    type: "questionInCircle",
    content: _i18n.i18n.translate('visDefaultEditor.controls.aggregateWithTooltip', {
      defaultMessage: 'Choose a strategy for combining multiple hits or a multi-valued field into a single metric.'
    })
  }));
  (0, _react.useEffect)(() => {
    setValidity(isValid);
  }, [isValid, setValidity]);
  (0, _react.useEffect)(() => {
    if (isFirstRun.current) {
      isFirstRun.current = false;
      return;
    }
    if (value) {
      if (aggParam.options.find(opt => opt.value === value.value)) {
        return;
      }
      setValue();
    }
    if (filteredOptions.length === 1) {
      setValue(aggParam.options.find(opt => opt.value === filteredOptions[0].value));
    }
  }, [aggParam.options, fieldType, filteredOptions, setValue, value]);
  const handleChange = event => {
    if (event.target.value === emptyValue.value) {
      setValue();
    } else {
      setValue(aggParam.options.find(opt => opt.value === event.target.value));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: options,
    value: value ? value.value : emptyValue.value,
    onChange: handleChange,
    fullWidth: true,
    compressed: true,
    isInvalid: showValidation ? !isValid : false,
    disabled: disabled,
    onBlur: setTouched,
    "data-test-subj": "visDefaultEditorAggregateWith"
  }));
}