"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrderByParamEditor = OrderByParamEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _public = require("@kbn/data-plugin/public");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  termsAggFilter
} = _public.search.aggs;
const DEFAULT_VALUE = '_key';
const DEFAULT_OPTIONS = [{
  text: _i18n.i18n.translate('visDefaultEditor.controls.orderAgg.alphabeticalLabel', {
    defaultMessage: 'Alphabetical'
  }),
  value: DEFAULT_VALUE
}];
const isCompatibleAgg = (0, _utils.isCompatibleAggregation)(termsAggFilter);
function OrderByParamEditor({
  agg,
  value,
  showValidation,
  setValue,
  setValidity,
  setTouched,
  metricAggs
}) {
  const label = _i18n.i18n.translate('visDefaultEditor.controls.orderAgg.orderByLabel', {
    defaultMessage: 'Order by'
  });
  const isValid = !!value;
  (0, _utils.useValidation)(setValidity, isValid);
  (0, _useMount.default)(() => {
    // setup the initial value of orderBy
    if (!value) {
      let respAgg = {
        id: DEFAULT_VALUE
      };
      if (metricAggs) {
        respAgg = metricAggs.filter(isCompatibleAgg)[0] || respAgg;
      }
      setValue(respAgg.id);
    }
  });
  (0, _utils.useFallbackMetric)(setValue, termsAggFilter, metricAggs, value, DEFAULT_VALUE);
  const options = (0, _utils.useAvailableOptions)(termsAggFilter, metricAggs, DEFAULT_OPTIONS);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation && !isValid,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: options,
    value: value,
    onChange: ev => setValue(ev.target.value),
    fullWidth: true,
    compressed: true,
    isInvalid: showValidation && !isValid,
    onBlur: setTouched,
    "data-test-subj": `visEditorOrderBy${agg.id}`
  }));
}