"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrderAggParamEditor = OrderAggParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _utils = require("./utils");
var _agg_params = require("../agg_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function OrderAggParamEditor({
  agg,
  aggParam,
  formIsTouched,
  value,
  metricAggs,
  state,
  setValue,
  setValidity,
  setTouched,
  schemas
}) {
  const orderBy = agg.params.orderBy;
  (0, _react.useEffect)(() => {
    if (orderBy === 'custom' && !value) {
      setValue(aggParam.makeAgg(agg));
    }
    if (orderBy !== 'custom' && value) {
      setValue(undefined);
    }
  }, [agg, aggParam, orderBy, setValue, value]);
  const {
    onAggTypeChange,
    setAggParamValue
  } = (0, _utils.useSubAggParamsHandlers)(agg, aggParam, value, setValue);
  if (!agg.params.orderAgg) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_agg_params.DefaultEditorAggParams, {
    agg: value,
    allowedAggs: aggParam.allowedAggs,
    hideCustomLabel: true,
    groupName: _public.AggGroupNames.Metrics,
    className: "visEditorAgg__subAgg",
    formIsTouched: formIsTouched,
    indexPattern: agg.getIndexPattern(),
    metricAggs: metricAggs,
    state: state,
    setAggParamValue: setAggParamValue,
    onAggTypeChange: onAggTypeChange,
    setValidity: setValidity,
    setTouched: setTouched,
    schemas: schemas
  }));
}