"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberIntervalParamEditor = NumberIntervalParamEditor;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visDefaultEditor.controls.numberInterval.minimumIntervalLabel",
  defaultMessage: "Minimum interval"
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  position: "right",
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.numberInterval.minimumIntervalTooltip",
    defaultMessage: "Interval will be automatically scaled in the event that the provided value creates more buckets than specified by Advanced Setting's {histogramMaxBars}",
    values: {
      histogramMaxBars: _public.UI_SETTINGS.HISTOGRAM_MAX_BARS
    }
  }),
  type: "questionInCircle"
}));
const autoInterval = 'auto';
const isAutoInterval = value => value === autoInterval;
const selectIntervalPlaceholder = _i18n.i18n.translate('visDefaultEditor.controls.numberInterval.selectIntervalPlaceholder', {
  defaultMessage: 'Enter an interval'
});
const autoIntervalIsUsedPlaceholder = _i18n.i18n.translate('visDefaultEditor.controls.numberInterval.autoInteralIsUsed', {
  defaultMessage: 'Auto interval is used'
});
const useAutoIntervalLabel = _i18n.i18n.translate('visDefaultEditor.controls.useAutoInterval', {
  defaultMessage: 'Use auto interval'
});
function NumberIntervalParamEditor({
  agg,
  editorConfig,
  showValidation,
  value,
  setTouched,
  setValidity,
  setValue
}) {
  const field = agg.getField();
  const fieldSupportsAuto = !field || field.type === 'number';
  const isAutoChecked = fieldSupportsAuto && isAutoInterval(value);
  const base = (0, _lodash.get)(editorConfig, 'interval.base');
  const min = base || 0;
  const isValid = value !== '' && value !== undefined && (isAutoChecked || Number(value) >= min);
  (0, _react.useEffect)(() => {
    setValidity(isValid);
  }, [isValid, setValidity]);
  const onChange = (0, _react.useCallback)(({
    target
  }) => setValue(isNaN(target.valueAsNumber) ? '' : target.valueAsNumber), [setValue]);
  const onAutoSwitchChange = (0, _react.useCallback)(e => {
    const isAutoSwitchChecked = e.target.checked;
    setValue(isAutoSwitchChecked ? autoInterval : '');
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: label,
    fullWidth: true,
    isInvalid: showValidation && !isValid,
    helpText: (0, _lodash.get)(editorConfig, 'interval.help')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: 'column'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: useAutoIntervalLabel,
    onChange: onAutoSwitchChange,
    checked: isAutoChecked,
    compressed: true,
    disabled: !fieldSupportsAuto,
    "data-test-subj": `visEditorIntervalSwitch${agg.id}`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: !isAutoChecked ? value : '',
    min: min,
    step: base || 'any',
    "data-test-subj": `visEditorInterval${agg.id}`,
    isInvalid: showValidation && !isValid,
    onChange: onChange,
    onBlur: setTouched,
    disabled: isAutoChecked,
    fullWidth: true,
    compressed: true,
    placeholder: isAutoChecked ? autoIntervalIsUsedPlaceholder : selectIntervalPlaceholder
  }))));
}