"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggParamsMap = void 0;
var _public = require("@kbn/data-plugin/public");
var controls = _interopRequireWildcard(require("./controls"));
var _utils = require("./controls/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  siblingPipelineType,
  parentPipelineType
} = _public.search.aggs;
const buckets = {
  [_public.BUCKET_TYPES.DATE_HISTOGRAM]: {
    scaleMetricValues: controls.ScaleMetricsParamEditor,
    interval: controls.TimeIntervalParamEditor,
    drop_partials: controls.DropPartialsParamEditor
  },
  [_public.BUCKET_TYPES.DATE_RANGE]: {
    ranges: controls.DateRangesParamEditor
  },
  [_public.BUCKET_TYPES.FILTERS]: {
    filters: controls.FiltersParamEditor
  },
  [_public.BUCKET_TYPES.HISTOGRAM]: {
    interval: controls.NumberIntervalParamEditor,
    maxBars: controls.MaxBarsParamEditor,
    min_doc_count: controls.MinDocCountParamEditor,
    has_extended_bounds: controls.HasExtendedBoundsParamEditor,
    extended_bounds: controls.ExtendedBoundsParamEditor
  },
  [_public.BUCKET_TYPES.IP_PREFIX]: {
    ipPrefix: controls.IpPrefixParamEditor
  },
  [_public.BUCKET_TYPES.IP_RANGE]: {
    ipRangeType: controls.IpRangeTypeParamEditor,
    ranges: controls.IpRangesParamEditor
  },
  [_public.BUCKET_TYPES.RANGE]: {
    ranges: controls.RangesControl
  },
  [_public.BUCKET_TYPES.SIGNIFICANT_TERMS]: {
    size: controls.SizeParamEditor
  },
  [_public.BUCKET_TYPES.TERMS]: {
    include: controls.IncludeExcludeParamEditor,
    exclude: controls.IncludeExcludeParamEditor,
    orderBy: controls.OrderByParamEditor,
    orderAgg: controls.OrderAggParamEditor,
    order: (0, _utils.wrapWithInlineComp)(controls.OrderParamEditor),
    size: (0, _utils.wrapWithInlineComp)(controls.SizeParamEditor),
    otherBucket: controls.OtherBucketParamEditor,
    missingBucket: controls.MissingBucketParamEditor
  }
};
const metrics = {
  [_public.METRIC_TYPES.TOP_HITS]: {
    field: controls.TopFieldParamEditor,
    aggregate: (0, _utils.wrapWithInlineComp)(controls.TopAggregateParamEditor),
    size: (0, _utils.wrapWithInlineComp)(controls.TopSizeParamEditor),
    sortField: controls.TopSortFieldParamEditor,
    sortOrder: controls.OrderParamEditor
  },
  [_public.METRIC_TYPES.TOP_METRICS]: {
    field: controls.FieldParamEditor,
    sortField: controls.TopSortFieldParamEditor,
    sortOrder: controls.OrderParamEditor
  },
  [_public.METRIC_TYPES.PERCENTILES]: {
    percents: controls.PercentilesEditor
  },
  [_public.METRIC_TYPES.PERCENTILE_RANKS]: {
    values: controls.PercentileRanksEditor
  }
};
const aggParamsMap = exports.aggParamsMap = {
  common: {
    string: controls.StringParamEditor,
    json: controls.RawJsonParamEditor,
    field: controls.FieldParamEditor
  },
  [siblingPipelineType]: {
    customBucket: controls.SubMetricParamEditor,
    customMetric: controls.SubMetricParamEditor
  },
  [parentPipelineType]: {
    metricAgg: controls.MetricAggParamEditor,
    customMetric: controls.SubAggParamEditor
  },
  [_public.AggGroupNames.Buckets]: buckets,
  [_public.AggGroupNames.Metrics]: metrics
};