"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceNameFilter = ServiceNameFilter;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _use_url_params = require("../../../../../context/url_params_context/use_url_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceNameFilter({
  loading,
  serviceNames
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams: {
      serviceName: selectedServiceName
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const options = (serviceNames !== null && serviceNames !== void 0 ? serviceNames : []).map(type => ({
    text: type,
    value: type
  }));
  const updateServiceName = (0, _react.useCallback)((serviceN, replaceHistory) => {
    const newLocation = {
      ...history.location,
      search: (0, _public.fromQuery)({
        ...(0, _public.toQuery)(history.location.search),
        serviceName: serviceN
      })
    };
    if (replaceHistory) {
      history.replace(newLocation);
    } else {
      history.push(newLocation);
    }
  }, [history]);
  (0, _react.useEffect)(() => {
    if (serviceNames && (serviceNames === null || serviceNames === void 0 ? void 0 : serviceNames.length) > 0) {
      // select first from the list
      if (!selectedServiceName) {
        updateServiceName(serviceNames[0], true);
      }

      // in case serviceName is cached from url and isn't present in current list
      if (selectedServiceName && !serviceNames.includes(selectedServiceName)) {
        updateServiceName(serviceNames[0], true);
      }
    }
    if (selectedServiceName && (serviceNames === null || serviceNames === void 0 ? void 0 : serviceNames.length) === 0 && !loading) {
      updateServiceName('');
    }
  }, [serviceNames, selectedServiceName, updateServiceName, loading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "uxServiceNameFilterSelect",
    fullWidth: true,
    prepend: _i18n.i18n.translate('xpack.ux.localFilters.titles.webApplication', {
      defaultMessage: 'Web application'
    }),
    isLoading: loading,
    "data-cy": "serviceNameFilter",
    options: options,
    value: selectedServiceName,
    onChange: event => {
      updateServiceName(event.target.value);
    }
  });
}