"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserToolTip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _user_avatar = require("./user_avatar");
var _user_profile = require("./user_profile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Props of {@link UserToolTip} component
 */

/**
 * Renders a tooltip with user information
 */
const UserToolTip = ({
  user,
  avatar,
  ...rest
}) => {
  const displayName = (0, _user_profile.getUserDisplayName)(user);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, (0, _extends2.default)({
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_user_avatar.UserAvatar, {
      user: user,
      avatar: avatar,
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("strong", null, displayName)), user.email && user.email !== displayName ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, user.email) : undefined)))
  }, rest));
};
exports.UserToolTip = UserToolTip;