"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLegacyUrlForwardApp = void 0;
var _navigate_to_legacy_kibana_url = require("./navigate_to_legacy_kibana_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createLegacyUrlForwardApp = (core, forwards) => ({
  id: 'kibana',
  chromeless: true,
  title: 'Legacy URL migration',
  appRoute: '/app/kibana#/',
  visibleIn: [],
  async mount(params) {
    const hash = params.history.location.hash.substr(1);
    const [{
      application,
      uiSettings,
      http: {
        basePath
      }
    }] = await core.getStartServices();
    const {
      navigated
    } = (0, _navigate_to_legacy_kibana_url.navigateToLegacyKibanaUrl)(hash, forwards, basePath, application);
    if (!navigated) {
      const defaultRoute = uiSettings.get('defaultRoute');
      application.navigateToUrl(basePath.prepend(defaultRoute));
    }
    return () => {};
  }
});
exports.createLegacyUrlForwardApp = createLegacyUrlForwardApp;