"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepsList = void 0;
exports.isStepEnd = isStepEnd;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../../monitor/ping_list/translations");
var _translations2 = require("../translations");
var _status_badge = require("../status_badge");
var _step_detail_link = require("../../common/step_detail_link");
var _translations3 = require("../../monitor/synthetics/translations");
var _step_image = require("./step_image");
var _use_expanded_row = require("./use_expanded_row");
var _step_duration = require("./step_duration");
var _uptime_settings_context = require("../../../contexts/uptime_settings_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isStepEnd(step) {
  var _step$synthetics;
  return ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : _step$synthetics.type) === 'step/end';
}
function statusMessage(count, loading) {
  if (loading) {
    return _i18n.i18n.translate('xpack.uptime.synthetics.journey.loadingSteps', {
      defaultMessage: 'Loading steps ...'
    });
  }
  const total = count.succeeded + count.failed + count.skipped;
  if (count.failed + count.skipped === total) {
    return _i18n.i18n.translate('xpack.uptime.synthetics.journey.allFailedMessage', {
      defaultMessage: '{total} Steps - all failed or skipped',
      values: {
        total
      }
    });
  } else if (count.succeeded === total) {
    return _i18n.i18n.translate('xpack.uptime.synthetics.journey.allSucceededMessage', {
      defaultMessage: '{total} Steps - all succeeded',
      values: {
        total
      }
    });
  }
  return _i18n.i18n.translate('xpack.uptime.synthetics.journey.partialSuccessMessage', {
    defaultMessage: '{total} Steps - {succeeded} succeeded',
    values: {
      succeeded: count.succeeded,
      total
    }
  });
}
function reduceStepStatus(prev, cur) {
  var _cur$synthetics, _cur$synthetics$paylo, _cur$synthetics2, _cur$synthetics2$payl;
  if (((_cur$synthetics = cur.synthetics) === null || _cur$synthetics === void 0 ? void 0 : (_cur$synthetics$paylo = _cur$synthetics.payload) === null || _cur$synthetics$paylo === void 0 ? void 0 : _cur$synthetics$paylo.status) === 'succeeded') {
    prev.succeeded += 1;
    return prev;
  } else if (((_cur$synthetics2 = cur.synthetics) === null || _cur$synthetics2 === void 0 ? void 0 : (_cur$synthetics2$payl = _cur$synthetics2.payload) === null || _cur$synthetics2$payl === void 0 ? void 0 : _cur$synthetics2$payl.status) === 'skipped') {
    prev.skipped += 1;
    return prev;
  }
  prev.failed += 1;
  return prev;
}
const StepsList = ({
  data,
  error,
  loading,
  allStepsLoaded,
  showStepDurationTrend = true,
  compactView = false
}) => {
  const steps = data.filter(isStepEnd);
  const {
    expandedRows,
    toggleExpand
  } = (0, _use_expanded_row.useExpandedRow)({
    steps,
    allSteps: data,
    loading
  });
  const [durationPopoverOpenIndex, setDurationPopoverOpenIndex] = (0, _react.useState)(null);
  const {
    basePath
  } = (0, _uptime_settings_context.useUptimeSettingsContext)();
  const columns = [{
    field: 'synthetics.payload.status',
    name: _translations.STATUS_LABEL,
    render: (pingStatus, item) => {
      var _item$synthetics, _item$synthetics$step;
      return /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
        status: pingStatus,
        stepNo: (_item$synthetics = item.synthetics) === null || _item$synthetics === void 0 ? void 0 : (_item$synthetics$step = _item$synthetics.step) === null || _item$synthetics$step === void 0 ? void 0 : _item$synthetics$step.index
      });
    },
    mobileOptions: {
      render: item => {
        var _item$synthetics2, _item$synthetics2$pay, _item$synthetics3, _item$synthetics3$ste;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
          isMobile: true,
          status: (_item$synthetics2 = item.synthetics) === null || _item$synthetics2 === void 0 ? void 0 : (_item$synthetics2$pay = _item$synthetics2.payload) === null || _item$synthetics2$pay === void 0 ? void 0 : _item$synthetics2$pay.status,
          stepNo: (_item$synthetics3 = item.synthetics) === null || _item$synthetics3 === void 0 ? void 0 : (_item$synthetics3$ste = _item$synthetics3.step) === null || _item$synthetics3$ste === void 0 ? void 0 : _item$synthetics3$ste.index
        }));
      },
      width: '20%',
      header: _translations.STATUS_LABEL,
      enlarge: false
    }
  }, {
    align: 'left',
    field: 'timestamp',
    name: _translations2.STEP_NAME_LABEL,
    render: (_timestamp, item) => /*#__PURE__*/_react.default.createElement(_step_image.StepImage, {
      step: item,
      compactView: compactView,
      allStepsLoaded: allStepsLoaded
    }),
    mobileOptions: {
      render: item => {
        var _item$synthetics4, _item$synthetics4$ste, _item$synthetics5, _item$synthetics5$ste;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, (_item$synthetics4 = item.synthetics) === null || _item$synthetics4 === void 0 ? void 0 : (_item$synthetics4$ste = _item$synthetics4.step) === null || _item$synthetics4$ste === void 0 ? void 0 : _item$synthetics4$ste.index, ". ", (_item$synthetics5 = item.synthetics) === null || _item$synthetics5 === void 0 ? void 0 : (_item$synthetics5$ste = _item$synthetics5.step) === null || _item$synthetics5$ste === void 0 ? void 0 : _item$synthetics5$ste.name));
      },
      header: 'Step',
      enlarge: true
    }
  }, {
    name: 'Step duration',
    render: item => {
      return /*#__PURE__*/_react.default.createElement(_step_duration.StepDuration, {
        step: item,
        durationPopoverOpenIndex: durationPopoverOpenIndex,
        setDurationPopoverOpenIndex: setDurationPopoverOpenIndex,
        showStepDurationTrend: showStepDurationTrend,
        compactView: compactView
      });
    },
    mobileOptions: {
      header: _i18n.i18n.translate('xpack.uptime.pingList.stepDurationHeader', {
        defaultMessage: 'Step duration'
      }),
      show: true
    }
  }, {
    align: 'left',
    field: 'timestamp',
    name: '',
    mobileOptions: {
      show: false
    },
    render: (_val, item) => {
      var _item$synthetics6, _item$synthetics6$ste, _item$synthetics7, _item$synthetics7$ste;
      return compactView ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "observabilitySolutionColumnsButton",
        href: `${basePath}/app/uptime/journey/${item.monitor.check_group}/step/${(_item$synthetics6 = item.synthetics) === null || _item$synthetics6 === void 0 ? void 0 : (_item$synthetics6$ste = _item$synthetics6.step) === null || _item$synthetics6$ste === void 0 ? void 0 : _item$synthetics6$ste.index}`,
        target: "_blank",
        iconType: "visArea"
      }) : /*#__PURE__*/_react.default.createElement(_step_detail_link.StepDetailLink, {
        checkGroupId: item.monitor.check_group,
        stepIndex: (_item$synthetics7 = item.synthetics) === null || _item$synthetics7 === void 0 ? void 0 : (_item$synthetics7$ste = _item$synthetics7.step) === null || _item$synthetics7$ste === void 0 ? void 0 : _item$synthetics7$ste.index
      }, _translations3.VIEW_PERFORMANCE);
    }
  }, {
    width: '40px',
    align: _eui.RIGHT_ALIGNMENT,
    isExpander: true,
    render: journeyStep => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "uptimeStepListExpandBtn",
        onClick: () => toggleExpand({
          journeyStep
        }),
        "aria-label": expandedRows[journeyStep._id] ? _translations2.COLLAPSE_LABEL : _translations2.EXPAND_LABEL,
        iconType: expandedRows[journeyStep._id] ? 'arrowUp' : 'arrowDown'
      });
    }
  }];
  const getRowProps = item => {
    const {
      monitor
    } = item;
    return {
      'data-test-subj': `row-${monitor.check_group}`,
      onClick: evt => {
        const targetElem = evt.target;

        // we dont want to capture image click event
        if (targetElem.tagName !== 'IMG' && targetElem.tagName !== 'BUTTON' && targetElem.tagName !== 'CANVAS' && !targetElem.classList.contains('euiButtonEmpty__text') && !targetElem.classList.contains('euiIcon')) {
          toggleExpand({
            journeyStep: item
          });
        }
      }
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !compactView && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, statusMessage(steps.reduce(reduceStepStatus, {
    failed: 0,
    skipped: 0,
    succeeded: 0
  }), loading))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    compressed: compactView,
    loading: loading,
    columns: columns,
    error: error === null || error === void 0 ? void 0 : error.message,
    isExpandable: true,
    hasActions: true,
    items: steps,
    itemIdToExpandedRowMap: expandedRows,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.uptime.pingList.pingsLoadingMesssage', {
      defaultMessage: 'Loading history...'
    }) : _i18n.i18n.translate('xpack.uptime.pingList.pingsUnavailableMessage', {
      defaultMessage: 'No history found'
    }),
    tableLayout: 'auto',
    rowProps: getRowProps
  }));
};
exports.StepsList = StepsList;