"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_IN_DISCOVER_LABEL = exports.TIMESTAMP_LABEL = exports.TEST_RUN_LOGS_LABEL = exports.StdErrorLogs = exports.ERROR_SUMMARY_LABEL = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_std_error_logs = require("./use_std_error_logs");
var _selectors = require("../../../state/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StdErrorLogs = ({
  monitorId,
  checkGroup,
  timestamp,
  title,
  summaryMessage,
  hideTitle = false
}) => {
  const columns = [{
    field: '@timestamp',
    name: TIMESTAMP_LABEL,
    sortable: true,
    render: date => (0, _eui.formatDate)(date, 'dateTime')
  }, {
    field: 'synthetics.payload.message',
    name: 'Message',
    render: message => /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: message.includes('SyntaxError:') ? 'SyntaxError:' : 'ReferenceError:'
    }, message)
  }];
  const {
    items,
    loading
  } = (0, _use_std_error_logs.useStdErrorLogs)({
    monitorId,
    checkGroup
  });
  const {
    discover,
    exploratoryView
  } = (0, _public.useKibana)().services;
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const {
    data: discoverLink
  } = (0, _public2.useFetcher)(async () => {
    if (settings !== null && settings !== void 0 && settings.heartbeatIndices) {
      var _discover$locator;
      const dataView = await exploratoryView.getAppDataView('synthetics', settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices);
      return (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getUrl({
        query: {
          language: 'kuery',
          query: `monitor.check_group: ${checkGroup}`
        },
        indexPatternId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
        columns: ['synthetics.payload.message', 'error.message'],
        timeRange: timestamp ? {
          from: (0, _moment.default)(timestamp).subtract(10, 'minutes').toISOString(),
          to: (0, _moment.default)(timestamp).add(5, 'minutes').toISOString()
        } : undefined
      });
    }
    return '';
  }, [checkGroup, timestamp]);
  const search = {
    box: {
      incremental: true
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideTitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title !== null && title !== void 0 ? title : TEST_RUN_LOGS_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsStdErrorLogsLink"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStdErrorLogsButton",
    href: discoverLink,
    iconType: "discoverApp",
    isDisabled: !discoverLink
  }, VIEW_IN_DISCOVER_LABEL)))), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: ERROR_SUMMARY_LABEL,
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, summaryMessage))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    columns: columns,
    tableLayout: "auto",
    loading: loading,
    search: search,
    itemId: "id",
    executeQueryOptions: {
      defaultFields: ['@timestamp', 'synthetics.payload.message']
    }
  }));
};
exports.StdErrorLogs = StdErrorLogs;
const TIMESTAMP_LABEL = exports.TIMESTAMP_LABEL = _i18n.i18n.translate('xpack.uptime.monitorList.timestamp', {
  defaultMessage: 'Timestamp'
});
const ERROR_SUMMARY_LABEL = exports.ERROR_SUMMARY_LABEL = _i18n.i18n.translate('xpack.uptime.monitorList.errorSummary', {
  defaultMessage: 'Error summary'
});
const VIEW_IN_DISCOVER_LABEL = exports.VIEW_IN_DISCOVER_LABEL = _i18n.i18n.translate('xpack.uptime.monitorList.viewInDiscover', {
  defaultMessage: 'View in discover'
});
const TEST_RUN_LOGS_LABEL = exports.TEST_RUN_LOGS_LABEL = _i18n.i18n.translate('xpack.uptime.monitorList.testRunLogs', {
  defaultMessage: 'Test run logs'
});