"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasFilters = exports.AlertMonitorStatusComponent = exports.AlertMonitorCount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _monitor_expressions = require("../monitor_expressions");
var _add_filter_btn = require("./add_filter_btn");
var _old_alert_call_out = require("./old_alert_call_out");
var _availability_expression_select = require("../monitor_expressions/availability_expression_select");
var _query_bar = require("../alert_query_bar/query_bar");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasFilters = filters => {
  if (!filters || Object.keys(filters).length === 0) {
    return false;
  }
  return Object.values(_constants.FILTER_FIELDS).some(f => filters[f].length);
};
exports.hasFilters = hasFilters;
const AlertMonitorStatusComponent = props => {
  var _ruleParams$filters;
  const {
    ruleParams,
    isOldAlert,
    setRuleParams,
    snapshotCount,
    snapshotLoading
  } = props;
  const alertFilters = (_ruleParams$filters = ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.filters) !== null && _ruleParams$filters !== void 0 ? _ruleParams$filters : {};
  const [newFilters, setNewFilters] = (0, _react.useState)(Object.keys(alertFilters).filter(f => alertFilters[f].length));
  const {
    search = ''
  } = (0, _hooks.useGetUrlParams)();
  (0, _react.useEffect)(() => {
    if (search) {
      setRuleParams('search', search);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onSearchChange = (0, _react.useCallback)(value => {
    setRuleParams('search', value);
  }, [setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_old_alert_call_out.OldAlertCallOut, {
    isOldAlert: isOldAlert
  }), /*#__PURE__*/_react.default.createElement(AlertMonitorCount, {
    count: snapshotCount,
    loading: snapshotLoading
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_query_bar.AlertQueryBar, {
    query: ruleParams.search || '',
    onChange: onSearchChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_add_filter_btn.AddFilterButton, {
    alertFilters: ruleParams.filters,
    newFilters: newFilters,
    onNewFilter: newFilter => {
      setNewFilters([...newFilters, newFilter]);
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_expressions.FiltersExpressionsSelect, {
    ruleParams: ruleParams,
    newFilters: newFilters,
    onRemoveFilter: removeFilter => {
      if (newFilters.includes(removeFilter)) {
        setNewFilters(newFilters.filter(item => item !== removeFilter));
      }
    },
    setRuleParams: setRuleParams,
    shouldUpdateUrl: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_monitor_expressions.StatusExpressionSelect, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams,
    hasFilters: hasFilters(ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.filters)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_availability_expression_select.AvailabilityExpressionSelect, {
    ruleParams: ruleParams,
    isOldAlert: isOldAlert,
    setRuleParams: setRuleParams,
    hasFilters: hasFilters(ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.filters)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.AlertMonitorStatusComponent = AlertMonitorStatusComponent;
const AlertMonitorCount = ({
  count,
  loading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "alertSnapShotCount"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.alerts.monitorStatus.monitorCallOut.title",
      defaultMessage: "This alert will apply to approximately {snapshotCount} monitors.",
      values: {
        snapshotCount: loading ? '...' : count
      }
    }), ' ', loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)),
    iconType: "iInCircle"
  });
};
exports.AlertMonitorCount = AlertMonitorCount;