"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAvailabilityValue = exports.AvailabilityReporting = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _tag_label = require("./tag_label");
var _translations = require("../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatAvailabilityValue = val => {
  const result = Math.round(val * 100) / 100;
  return result.toFixed(2);
};
exports.formatAvailabilityValue = formatAvailabilityValue;
const AvailabilityReporting = ({
  allLocations
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const cols = [{
    field: 'label',
    name: _translations.LocationLabel,
    truncateText: true,
    render: (val, item) => {
      return /*#__PURE__*/_react.default.createElement(_tag_label.TagLabel, item);
    }
  }, {
    field: 'availability',
    name: _translations.AvailabilityLabel,
    align: 'right',
    render: val => {
      return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.uptime.availabilityLabelText",
        defaultMessage: "{value} %",
        values: {
          value: formatAvailabilityValue(val)
        },
        description: "A percentage value, like 23.5%"
      }));
    }
  }, {
    name: _translations.LastCheckLabel,
    field: 'timestamp',
    align: 'right'
  }];
  const pageSize = 5;
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: allLocations.length,
    showPerPageOptions: false
  };
  const onTableChange = ({
    page
  }) => {
    var _page$index;
    setPageIndex((_page$index = page === null || page === void 0 ? void 0 : page.index) !== null && _page$index !== void 0 ? _page$index : 0);
  };
  const paginationProps = allLocations.length > pageSize ? {
    pagination
  } : {};
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({
    responsive: false,
    compressed: true,
    columns: cols,
    items: allLocations.slice(pageIndex * pageSize, pageIndex * pageSize + pageSize),
    onChange: onTableChange
  }, paginationProps)));
};
exports.AvailabilityReporting = AvailabilityReporting;