"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatDuration = exports.SpanWithMargin = exports.PingList = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helper = require("../../../lib/helper");
var _use_pings = require("./use_pings");
var _ping_list_header = require("./ping_list_header");
var _ping_list_table = require("./ping_list_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SpanWithMargin = exports.SpanWithMargin = _styledComponents.default.span`
  margin-right: 16px;
`;
const DEFAULT_PAGE_SIZE = 10;

// one second = 1 million micros
const ONE_SECOND_AS_MICROS = 1000000;

// the limit for converting to seconds is >= 1 sec
const MILLIS_LIMIT = ONE_SECOND_AS_MICROS * 1;
const formatDuration = durationMicros => {
  if (durationMicros < MILLIS_LIMIT) {
    return _i18n.i18n.translate('xpack.uptime.pingList.durationMsColumnFormatting', {
      values: {
        millis: (0, _helper.convertMicrosecondsToMilliseconds)(durationMicros)
      },
      defaultMessage: '{millis} ms'
    });
  }
  const seconds = (durationMicros / ONE_SECOND_AS_MICROS).toFixed(0);

  // we format seconds with correct pluralization here and not for `ms` because it is much more likely users
  // will encounter times of exactly '1' second.
  if (seconds === '1') {
    return _i18n.i18n.translate('xpack.uptime.pingist.durationSecondsColumnFormatting.singular', {
      values: {
        seconds
      },
      defaultMessage: '{seconds} second'
    });
  }
  return _i18n.i18n.translate('xpack.uptime.pingist.durationSecondsColumnFormatting', {
    values: {
      seconds
    },
    defaultMessage: '{seconds} seconds'
  });
};
exports.formatDuration = formatDuration;
const PingList = () => {
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const {
    error,
    loading,
    pings,
    total,
    failedSteps
  } = (0, _use_pings.usePingsList)({
    pageSize,
    pageIndex
  });
  const pagination = {
    initialPageSize: DEFAULT_PAGE_SIZE,
    pageIndex,
    pageSize,
    pageSizeOptions: [10, 25, 50, 100],
    totalItemCount: total
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_ping_list_header.PingListHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_ping_list_table.PingListTable, {
    onChange: criteria => {
      setPageSize(criteria.page.size);
      setPageIndex(criteria.page.index);
    },
    error: error,
    pings: pings,
    loading: loading,
    pagination: pagination,
    failedSteps: failedSteps
  }));
};
exports.PingList = PingList;