"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDuration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _hooks = require("../../../hooks");
var _actions = require("../../../state/actions");
var _selectors = require("../../../state/selectors");
var _contexts = require("../../../contexts");
var _monitor_duration = require("./monitor_duration");
var _lib = require("../../../../../common/lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorDuration = ({
  monitorId
}) => {
  var _durationLines$locati;
  const {
    dateRangeStart,
    dateRangeEnd,
    absoluteDateRangeStart,
    absoluteDateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    durationLines,
    loading
  } = (0, _reactRedux.useSelector)(_selectors.selectDurationLines);
  const isMLAvailable = (0, _reactRedux.useSelector)(_selectors.hasMLFeatureSelector);
  const {
    data: mlJobs,
    loading: jobsLoading
  } = (0, _reactRedux.useSelector)(_selectors.hasMLJobSelector);
  const hasMLJob = !!(mlJobs !== null && mlJobs !== void 0 && mlJobs.jobsExist) && !!mlJobs.jobs.find(job => job.id === (0, _lib.getMLJobId)(monitorId));
  const anomalies = (0, _reactRedux.useSelector)(_selectors.anomaliesSelector);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  (0, _react.useEffect)(() => {
    if (isMLAvailable && hasMLJob) {
      const anomalyParams = {
        listOfMonitorIds: [monitorId],
        dateStart: absoluteDateRangeStart,
        dateEnd: absoluteDateRangeEnd
      };
      dispatch(_actions.getAnomalyRecordsAction.get(anomalyParams));
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dateRangeStart, dateRangeEnd, dispatch, lastRefresh, monitorId, isMLAvailable, hasMLJob]);
  (0, _react.useEffect)(() => {
    const params = {
      monitorId,
      dateStart: dateRangeStart,
      dateEnd: dateRangeEnd
    };
    dispatch((0, _actions.getMonitorDurationAction)(params));
  }, [dateRangeStart, dateRangeEnd, dispatch, lastRefresh, monitorId]);
  (0, _react.useEffect)(() => {
    dispatch(_actions.getMLCapabilitiesAction.get());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_monitor_duration.MonitorDurationComponent, {
    anomalies: anomalies,
    hasMLJob: hasMLJob,
    loading: loading || jobsLoading,
    locationDurationLines: (_durationLines$locati = durationLines === null || durationLines === void 0 ? void 0 : durationLines.locationDurationLines) !== null && _durationLines$locati !== void 0 ? _durationLines$locati : []
  });
};
exports.MonitorDuration = MonitorDuration;