"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowLicenseInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _contexts = require("../../../contexts");
var labels = _interopRequireWildcard(require("./translations"));
var _actions = require("../../../state/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShowLicenseInfo = () => {
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_actions.getMLCapabilitiesAction.get());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "uptimeMLLicenseInfo",
    className: "license-info-trial",
    title: labels.START_TRAIL,
    color: "primary",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, labels.START_TRAIL_DESC), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsShowLicenseInfoButton",
    color: "primary",
    href: basePath + `/app/management/stack/license_management/home`
  }, labels.START_TRAIL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.ShowLicenseInfo = ShowLicenseInfo;