"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactRouterHelperForEui = exports.ReactRouterEuiLink = exports.ReactRouterEuiButtonEmpty = exports.ReactRouterEuiButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _link_events = require("./link_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generates either an EuiLink or EuiButton with a React-Router-ified link
 *
 * Based off of EUI's recommendations for handling React Router:
 * https://github.com/elastic/eui/blob/master/wiki/react-router.md#react-router-51
 */

const ReactRouterHelperForEui = ({
  to,
  children
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const onClick = event => {
    if ((0, _link_events.letBrowserHandleEvent)(event)) return;

    // Prevent regular link behavior, which causes a browser refresh.
    event.preventDefault();

    // Push the route to the history.
    history.push(to);
  };

  // Generate the correct link href (with basename etc. accounted for)
  const href = history.createHref({
    pathname: to
  });
  const reactRouterProps = {
    href,
    onClick
  };
  return /*#__PURE__*/_react.default.cloneElement(children, reactRouterProps);
};
exports.ReactRouterHelperForEui = ReactRouterHelperForEui;
const ReactRouterEuiLink = ({
  to,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(ReactRouterHelperForEui, {
  to: to
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
  "data-test-subj": "syntheticsReactRouterEuiLinkLink"
}, rest)));
exports.ReactRouterEuiLink = ReactRouterEuiLink;
const ReactRouterEuiButton = ({
  to,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(ReactRouterHelperForEui, {
  to: to
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
  "data-test-subj": "syntheticsReactRouterEuiButtonButton"
}, rest)));
exports.ReactRouterEuiButton = ReactRouterEuiButton;
const ReactRouterEuiButtonEmpty = ({
  to,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(ReactRouterHelperForEui, {
  to: to
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  "data-test-subj": "syntheticsReactRouterEuiButtonEmptyButton"
}, rest)));
exports.ReactRouterEuiButtonEmpty = ReactRouterEuiButtonEmpty;