"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPTIME_RULE_TYPES = exports.TLS_LEGACY = exports.TLS = exports.MONITOR_STATUS = exports.DURATION_ANOMALY = exports.CLIENT_ALERT_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_STATUS = exports.MONITOR_STATUS = {
  id: 'xpack.uptime.alerts.actionGroups.monitorStatus',
  name: 'Uptime Down Monitor'
};
const TLS_LEGACY = exports.TLS_LEGACY = {
  id: 'xpack.uptime.alerts.actionGroups.tls',
  name: 'Uptime TLS Alert (Legacy)'
};
const TLS = exports.TLS = {
  id: 'xpack.uptime.alerts.actionGroups.tlsCertificate',
  name: 'Uptime TLS Alert'
};
const DURATION_ANOMALY = exports.DURATION_ANOMALY = {
  id: 'xpack.uptime.alerts.actionGroups.durationAnomaly',
  name: 'Uptime Duration Anomaly'
};
const CLIENT_ALERT_TYPES = exports.CLIENT_ALERT_TYPES = {
  MONITOR_STATUS: 'xpack.uptime.alerts.monitorStatus',
  TLS_LEGACY: 'xpack.uptime.alerts.tls',
  TLS: 'xpack.uptime.alerts.tlsCertificate',
  DURATION_ANOMALY: 'xpack.uptime.alerts.durationAnomaly'
};
const UPTIME_RULE_TYPES = exports.UPTIME_RULE_TYPES = ['xpack.uptime.alerts.tls', 'xpack.uptime.alerts.tlsCertificate', 'xpack.uptime.alerts.monitorStatus', 'xpack.uptime.alerts.durationAnomaly'];