"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _types = require("../../../../../../../common/types");
var _checklist_step = require("./checklist_step");
var _warnings_step = require("./warnings_step");
var _shared = require("../../../../shared");
var _ui_metric = require("../../../../../lib/ui_metric");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReindexFlyout = ({
  reindexState,
  startReindex,
  cancelReindex,
  closeFlyout,
  deprecation
}) => {
  var _reindexState$reindex;
  const {
    status,
    reindexWarnings
  } = reindexState;
  const {
    index
  } = deprecation;
  const [showWarningsStep, setShowWarningsStep] = (0, _react.useState)(false);
  const onStartReindex = (0, _react.useCallback)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_START_CLICK);
    startReindex();
  }, [startReindex]);
  const onStopReindex = (0, _react.useCallback)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_STOP_CLICK);
    cancelReindex();
  }, [cancelReindex]);
  const startReindexWithWarnings = () => {
    if (reindexWarnings && reindexWarnings.length > 0 && status !== _types.ReindexStatus.inProgress && status !== _types.ReindexStatus.completed) {
      setShowWarningsStep(true);
    } else {
      onStartReindex();
    }
  };
  const flyoutContents = showWarningsStep ? /*#__PURE__*/_react.default.createElement(_warnings_step.WarningsFlyoutStep, {
    warnings: (_reindexState$reindex = reindexState.reindexWarnings) !== null && _reindexState$reindex !== void 0 ? _reindexState$reindex : [],
    meta: reindexState.meta,
    hideWarningsStep: () => setShowWarningsStep(false),
    continueReindex: () => {
      setShowWarningsStep(false);
      onStartReindex();
    }
  }) : /*#__PURE__*/_react.default.createElement(_checklist_step.ChecklistFlyoutStep, {
    closeFlyout: closeFlyout,
    startReindex: startReindexWithWarnings,
    reindexState: reindexState,
    cancelReindex: onStopReindex
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    isCritical: deprecation.isCritical,
    isResolved: status === _types.ReindexStatus.completed
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "reindexDetailsFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.flyoutHeader",
    defaultMessage: "Reindex {index}",
    values: {
      index
    }
  })))), flyoutContents);
};
exports.ReindexFlyout = ReindexFlyout;