"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoveClusterSettingsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _ui_metric = require("../../../../lib/ui_metric");
var _shared = require("../../../shared");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  removeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.removeClusterSettingsFlyout.removeButtonLabel', {
    defaultMessage: 'Remove deprecated settings'
  }),
  retryRemoveButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.removeClusterSettingsFlyout.retryRemoveButtonLabel', {
    defaultMessage: 'Retry removing deprecated settings'
  }),
  resolvedButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.removeClusterSettingsFlyout.resolvedButtonLabel', {
    defaultMessage: 'Resolved'
  }),
  closeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.removeClusterSettingsFlyout.closeButtonLabel', {
    defaultMessage: 'Close'
  }),
  getConfirmationText: clusterSettingsCount => _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.removeClusterSettingsFlyout.description', {
    defaultMessage: 'Remove the following deprecated cluster {clusterSettingsCount, plural, one {setting} other {settings}}?',
    values: {
      clusterSettingsCount
    }
  }),
  errorTitle: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.removeClusterSettingsFlyout.deleteErrorTitle', {
    defaultMessage: 'Error deleting cluster settings'
  })
};
const RemoveClusterSettingsFlyout = ({
  deprecation,
  closeFlyout,
  removeClusterSettings,
  status
}) => {
  const {
    message,
    details,
    url,
    correctiveAction
  } = deprecation;
  const {
    statusType,
    details: statusDetails
  } = status;

  // Flag used to hide certain parts of the UI if the deprecation has been resolved or is in progress
  const isResolvable = ['idle', 'error'].includes(statusType);
  const onRemoveSettings = (0, _react.useCallback)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_CLUSTER_SETTINGS_DELETE_CLICK);
    removeClusterSettings(correctiveAction.deprecatedSettings);
  }, [correctiveAction, removeClusterSettings]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    isCritical: deprecation.isCritical,
    isResolved: statusType === 'complete'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "removeClusterSettingsDetailsFlyoutTitle"
  }, message))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, statusType === 'error' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.errorTitle,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "deleteClusterSettingsError"
  }, statusDetails.message), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, details), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_shared.DeprecationFlyoutLearnMoreLink, {
    documentationUrl: url
  }))), isResolvable && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "removeClusterSettingsPrompt"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18nTexts.getConfirmationText(correctiveAction.deprecatedSettings.length))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, correctiveAction.deprecatedSettings.map(setting => /*#__PURE__*/_react.default.createElement("li", {
    key: setting
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, setting))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left"
  }, i18nTexts.closeButtonLabel)), isResolvable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "deleteClusterSettingsButton",
    color: "danger",
    onClick: onRemoveSettings
  }, statusType === 'error' ? i18nTexts.retryRemoveButtonLabel : i18nTexts.removeButtonLabel)))));
};
exports.RemoveClusterSettingsFlyout = RemoveClusterSettingsFlyout;