"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionComponent = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getEuiIconType(type) {
  switch (type) {
    case 'field':
      return 'kqlField';
    case 'value':
      return 'kqlValue';
    case 'recentSearch':
      return 'search';
    case 'conjunction':
      return 'kqlSelector';
    case 'operator':
      return 'kqlOperand';
    default:
      throw new Error(`Unknown type: ${type}`);
  }
}
const SuggestionComponent = exports.SuggestionComponent = /*#__PURE__*/_react.default.memo(function SuggestionComponent(props) {
  const {
    index,
    innerRef,
    onClick,
    onMouseEnter,
    suggestion
  } = props;
  const setRef = (0, _react.useCallback)(node => {
    innerRef(index, node);
  }, [index, innerRef]);
  const handleClick = (0, _react.useCallback)(() => {
    onClick(suggestion, index);
  }, [index, onClick, suggestion]);
  const handleMouseEnter = (0, _react.useCallback)(() => {
    onMouseEnter(suggestion, index);
  }, [index, onMouseEnter, suggestion]);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/interactive-supports-focus
    _react.default.createElement("div", {
      className: (0, _classnames.default)({
        // eslint-disable-next-line @typescript-eslint/naming-convention
        kbnTypeahead__item: true,
        active: props.selected
      }),
      role: "option",
      onMouseEnter: handleMouseEnter,
      onClick: handleClick,
      ref: setRef,
      id: props.ariaId,
      "aria-selected": props.selected,
      "data-test-subj": `autocompleteSuggestion-${props.suggestion.type}-${props.suggestion.text.replace(/\s/g, '-')}`
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)({
        kbnSuggestionItem: true,
        ['kbnSuggestionItem--' + props.suggestion.type]: true
      })
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "kbnSuggestionItem__type"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: getEuiIconType(props.suggestion.type)
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "kbnSuggestionItem__text",
      "data-test-subj": "autoCompleteSuggestionText"
    }, props.suggestion.text), props.shouldDisplayDescription && /*#__PURE__*/_react.default.createElement("div", {
      className: "kbnSuggestionItem__description",
      "data-test-subj": "autoCompleteSuggestionDescription"
    }, props.suggestion.description)))
  );
});